/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Michael Nimz <michael.nimz@open-xchange.com>
 */

define([
    'io.ox/office/baseframework/app/extensionregistry'
], function (ExtensionRegistry) {

    'use strict';

    // static class ExtensionRegistry =========================================

    describe('BaseFramework module ExtensionRegistry', function () {

        it('should exist', function () {
            expect(ExtensionRegistry).to.be.an('object');
        });

        it('should return the correct module type', function () {
            expect(ExtensionRegistry.getExtensionSettings('bla.xlsx').editable).to.equal(true);
        });

        it('should return the correct module name', function () {
            expect(ExtensionRegistry.getEditModule('bla.xlsx')).to.equal('io.ox/office/spreadsheet');
        });
    });

    // ========================================================================
});
