/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/view/dialogs', [
    'io.ox/office/editframework/view/editdialogs',
    'io.ox/office/spreadsheet/view/dialog/sheetnamedialog',
    'io.ox/office/spreadsheet/view/dialog/sheetorderdialog',
    'io.ox/office/spreadsheet/view/dialog/definednamedialog',
    'io.ox/office/spreadsheet/view/dialog/functiondialog',
    'io.ox/office/spreadsheet/view/dialog/unhidesheetsdialog',
    'io.ox/office/spreadsheet/view/dialog/customsortdialog'
], function (EditDialogs, SheetNameDialog, SheetOrderDialog, DefinedNameDialog, FunctionDialog, UnhideSheetsDialog, CustomSortDialog) {

    'use strict';

    // static class SpreadsheetDialogs ========================================

    /**
     * Collects all standard dialog classes defined in the toolkit and the base
     * framework, and adds more dialog classes in a single map for convenience.
     *
     * @extends EditDialogs
     */
    var SpreadsheetDialogs = _.extend({}, EditDialogs, {
        SheetNameDialog: SheetNameDialog,
        SheetOrderDialog: SheetOrderDialog,
        DefinedNameDialog: DefinedNameDialog,
        FunctionDialog: FunctionDialog,
        UnhideSheetsDialog: UnhideSheetsDialog,
        CustomSortDialog: CustomSortDialog
    });

    // exports ================================================================

    return SpreadsheetDialogs;

});
