/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/view/dialog/sheetnamedialog', [
    'io.ox/office/tk/dialog/inputdialog',
    'gettext!io.ox/office/spreadsheet/main'
], function (InputDialog, gt) {

    'use strict';

    // class SheetNameDialog ==================================================

    /**
     * Shows a dialog that allows to enter a sheet name, and will invoke an
     * arbitrary callback function for the sheet name. The dialog will be
     * kept open until a valid sheet name has been entered.
     *
     * @constructor
     *
     * @extends InputDialog
     *
     * @param {SpreadsheetView} docView
     *  The spreadsheet view instance that has created this dialog.
     *
     * @param {Function} actionHandler
     *  The callback function invoked when the OK button of the dialog has
     *  been clicked. Receives the current sheet name entered in the dialog,
     *  and MUST return a promise that states whether the operation using the
     *  sheet name has been finished successfully. In case of an error, the
     *  dialog will be kept open.
     *
     * @param {Object} [initOptions]
     *  Optional parameters. Supports most options of the base class
     *  InputDialog, except for "maxLength" and "placeholder".
     */
    var SheetNameDialog = InputDialog.extend(function (docView, actionHandler, initOptions) {

        // base constructor
        InputDialog.call(this, docView, _.extend(initOptions, {
            maxLength: docView.getDocModel().getMaxSheetNameLength(),
            placeholder: gt('Enter sheet name')
        }));

        // initialization -----------------------------------------------------

        // close dialog automatically after losing edit rights
        docView.closeDialogOnReadOnlyMode(this);

        // register the action handler for the OK button
        this.setOkHandler(function () {
            return actionHandler.call(this, this.getText());
        }, { keepOpen: 'fail' });

    }); // class SheetNameDialog

    // exports ================================================================

    return SheetNameDialog;

});
