/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/drawing/text/fieldmanager', [
    'io.ox/office/tk/object/triggerobject'
], function (TriggerObject) {

    'use strict';

    // class FieldManager =====================================================

    /**
     * An instance of this class represents the dispatcher for all simple and
     * complex fields in the edited document.
     *
     * @constructor
     *
     * @extends TriggerObject
     *
     * @param {SpreadsheetModel} docModel
     *  The spreadsheet document model.
     */
    var FieldManager = TriggerObject.extend({ constructor: function (docModel) {

        // base constructors --------------------------------------------------

        TriggerObject.call(this, docModel);

        // public methods -----------------------------------------------------

        this.updateComplexFieldCollector = _.noop;

        this.handlePasteOperationTarget = _.noop;

        this.checkRestoringSpecialFields = _.noop;

        this.removeAllFieldsInNode = _.noop;

        this.checkIfSpecialFieldsSelected = _.constant(false);

        // initialization -----------------------------------------------------

        // destroy all class members on destruction
        this.registerDestructor(function () {
            docModel = null;
        });

    } }); // class FieldManager

    // export =================================================================

    return FieldManager;
});
