/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Edy Haryono <edy.haryono@open-xchange.com>
 */

define('io.ox/office/presenter/views/sidebar/participantsview', [
    'io.ox/backbone/disposable',
    'io.ox/office/presenter/views/sidebar/userbadgeview',
    'gettext!io.ox/office/presenter/main'
], function (DisposableView, UserbadgeView, gt) {

    'use strict';

    var participantsView = DisposableView.extend({

        className: 'presenter-sidebar-section',

        initialize: function (options) {
            _.extend(this, options);

            this.on('dispose', this.disposeView.bind(this));
            this.listenTo(this.presenterEvents, 'presenter:participants:change', this.render);
        },

        render: function () {
            var sectionHeading   = $('<div class="sidebar-section-heading">');
            var headline         = $('<h3 class="sidebar-section-headline">').text('Participants');
            var sectionBody      = $('<div class="sidebar-section-body">');
            var participantsList = $('<ul class="participants-list">');

            var participants     = this.app.rtModel.get('participants');

            _.each(participants, function (participant) {
                var userbadgeView = new UserbadgeView({ participant: participant, app: this.app });
                participantsList.append(userbadgeView.render().el);
            }.bind(this));

            if (participants.length === 0) {
                //#. info text in the participants list.
                var notification = $('<li>').text(gt('There are currently no participants.'));
                participantsList.append(notification);
            }

            sectionHeading.append(headline);
            sectionBody.append(participantsList);
            this.$el.empty().append(sectionHeading, sectionBody);

            return this;
        },

        disposeView: function () {
            //console.info('ParticipantsView.disposeView()');
        }

    });

    return participantsView;
});
