/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Mario Schroeder <mario.schroeder@open-xchange.com>
 */

/* eslint no-new: 0 */

define('io.ox/office/presenter/fileactions', [
    'io.ox/core/extensions',
    'io.ox/core/extPatterns/actions',
    'io.ox/core/extPatterns/links',
    'io.ox/office/tk/utils/presenterutils',
    'io.ox/backbone/mini-views/contextmenu-utils',
    'gettext!io.ox/office/presenter/main'

], function (Ext, ActionsPattern, LinksPattern, PresenterUtils, ContextUtils, gt) {

    'use strict';

    // static class FileActions ===============================================

    var FileActions = {};

    var PRESENTER_ACTION_ID = 'io.ox/office/presenter/actions';

    // static private functions ===============================================

    function canPresent(model) {
        var type = getMimeType(model);
        return ((model.isPresentation(type) || model.isPDF(type)) && model.isFile());
    }

    function getMimeType(model) {
        return (model.isEncrypted() ? model.getGuardMimeType() : model.getMimeType());
    }

    function isConversionError(model) {
        var meta = model.get('meta');
        return (meta && meta.document_conversion_error && meta.document_conversion_error.length > 0);
    }

    // public methods ---------------------------------------------------------

    // static initialization ==================================================

    new ActionsPattern.Action(PRESENTER_ACTION_ID + '/launchpresenter/file', {
        capabilities: 'presenter',
        requires: function (e) {
            if (!e.collection.has('one', 'read')) {
                return false;
            }

            var model = e.baton.models[0];
            return (!isConversionError(model) && canPresent(model));
        },
        action: function (baton) {
            PresenterUtils.launchPresenter(baton.models[0]);
        }
    });

    var link = {
        id: 'launchpresenter_file',
        index: 650,
        prio: 'hi',
        mobile: 'lo',
        label: /*#. launch the presenter app */ gt('Present'),
        icon: 'fa fa-play-circle-o',
        ref: PRESENTER_ACTION_ID + '/launchpresenter/file'
    };

    // define link for the OX Presenter launch action in the OX Viewer toolbar.
    Ext.point('io.ox/core/viewer/toolbar/links/drive').extend(new LinksPattern.Link(link));
    Ext.point('io.ox/core/viewer/toolbar/links/guardDrive').extend(new LinksPattern.Link(link));

    // define link for the OX Presenter launch action in the OX Drive toolbar.
    link.index = 450;
    Ext.point('io.ox/files/classic-toolbar/links').extend(new LinksPattern.Link(link));
    //  58925: workaround to hide toolbar on smartphones because the toolbar is currently not handled correctly
    if (!_.device('smartphone')) {
        link.index = 350;
        Ext.point('io.ox/files/favorite/classic-toolbar/links').extend(new LinksPattern.Link(link));
    }

    Ext.point('io.ox/core/file/contextmenu/default/items').extend({
        id: 'launchpresenter_file',
        index: 1075,
        ref: PRESENTER_ACTION_ID + '/launchpresenter/file',
        section: '10',
        label: gt('Present')
    });

    // exports ================================================================

    return FileActions;

});
