/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Edy Haryono <edy.haryono@open-xchange.com>
 */

define('io.ox/office/portal/view/toolbarview', [
    'io.ox/office/portal/portalutils',
    'io.ox/office/portal/action/toolbaractionstext',
    'io.ox/office/portal/action/toolbaractionsspreadsheet',
    'io.ox/office/portal/action/toolbaractionspresentation',
    'io.ox/core/extensions'
], function (PortalUtils, ToolbarActionsText, ToolbarActionsSpreadsheet, ToolbarActionsPresentation, Ext) {

    'use strict';

    var toolbarView = Backbone.View.extend({

        tagName: 'div',

        className: 'office-portal-toolbar',

        events: {

        },

        initialize: function () {

            this.render(PortalUtils.getActiveApp(this.model, { translated: false }));

        },

        render: function (appBaseName) {

            this.$el.find('.office-portal-toolbar').remove();

            // create portal toolbar markup
            var toolbar = $('<div>').addClass('office-portal-toolbar f6-target').attr('role', 'toolbar');

            if ((_.browser.Android) && (appBaseName === 'text') && !PortalUtils.CHROME_ON_ANDROID) { toolbar.addClass('reduced-toolbar-functionality'); }

            // append to root element of this view
            this.$el.prepend(toolbar);

            // create all toolbar extension points, actions, and draw them.
            if (appBaseName === 'spreadsheet') {
                ToolbarActionsSpreadsheet.toolbarPoint.invoke('draw', toolbar, Ext.Baton({ app: this.model }));
            }

            if (appBaseName === 'text') {
                ToolbarActionsText.toolbarPoint.invoke('draw', toolbar, Ext.Baton({ app: this.model }));
            }

            if (appBaseName === 'presentation') {
                ToolbarActionsPresentation.toolbarPoint.invoke('draw', toolbar, Ext.Baton({ app: this.model }));
            }

            // adding tooltips to all links in the tool bar
            _.each(toolbar.children('a'), function (oneLink) {
                var oneLink$ = $(oneLink);

                if (oneLink$.attr('title')) {
                    oneLink$
                    .attr({
                        'data-toggle': 'tooltip',
                        title: oneLink$.attr('title')
                    });
                }
            });

            return this;
        }
    });

    return toolbarView;

});
