/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Edy Haryono <edy.haryono@open-xchange.com>
 */

define('io.ox/office/portal/collection/documentcollection', [
    'io.ox/office/portal/model/documentmodel'
], function (DocumentModel) {

    'use strict';

    /**
     * Filters the path property of a recent file entry for specific
     * infostore folders.
     *
     * @param {Array} recents
     *  an array with recent file data objects provided by the REST call
     *  'getrecentfilesandtemplates'.
     *
     * @returns {Array}
     *  An array of recent file data objects where the path property was
     *  filtered (removing specific folders, e.g. root & drive)
     */
    function filterRecentsPath(recents) {
        _.each(recents, function (recentFile) {
            recentFile.path = _.filter(recentFile.path || [], function (folder) {
                return ((folder.id !== '1') && (folder.id !== '9'));
            });
        });
        return recents;
    }

    var documentCollection = Backbone.Collection.extend({

        model: DocumentModel,

        setData: function (recentsArray) {

            var self = this;

            recentsArray = filterRecentsPath(recentsArray);

            // populate the collection with recent documents and
            // invokes an 'update' event that re-renders the view
            // TODO refactor: to risky to remove it before release, but
            // merge=true should not be needed here, it's the default for 'set'
            self.set(recentsArray, { merge: true });

        }

    });

    return documentCollection;

});
