/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/editframework/view/dialog/saveasfiledialog', [
    'io.ox/office/tk/dialog/saveasdialog'
], function (SaveAsDialog) {

    'use strict';

    // class SaveAsFileDialog =================================================

    /**
     * A custom dialog to save a file in a Drive folder. This dialog provides a
     * folder picker and a simple text input.
     *
     * @constructor
     *
     * @extends SaveAsDialog
     *
     * @param {EditView} docView
     *  The document view that has created this dialog.
     *
     * @param {String} title
     *  The title of the dialog.
     *
     * @param {String} fileName
     *  The initial file name to be shown in the text edit control.
     */
    var SaveAsFileDialog = SaveAsDialog.extend(function (docView, title, fileName) {

        // base constructor
        SaveAsDialog.call(this, docView, {
            title: title,
            value: fileName,
            folderId: docView.getApp().getFileParameters().folder_id,
            createFolderButton: true
        });

    }); // class SaveAsFileDialog

    // exports ================================================================

    return SaveAsFileDialog;

});
