/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/drawinglayer/view/drawingdialogs', [
    'io.ox/office/drawinglayer/view/dialog/insertimagedrivedialog',
    'io.ox/office/drawinglayer/view/dialog/insertimagefiledialog',
    'io.ox/office/drawinglayer/view/dialog/insertimageurldialog'
], function (InsertImageDriveDialog, InsertImageFileDialog, InsertImageURLDialog) {

    'use strict';

    // static class DrawingDialogs ============================================

    /**
     * Provides different classes for dialogs for drawing objects in a single
     * map for convenience.
     */
    var DrawingDialogs = {
        InsertImageDriveDialog: InsertImageDriveDialog,
        InsertImageFileDialog: InsertImageFileDialog,
        InsertImageURLDialog: InsertImageURLDialog
    };

    // exports ================================================================

    return DrawingDialogs;

});
