/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define([
    'globals/apphelper',
    'globals/sheethelper',
    'io.ox/office/spreadsheet/model/cellmodel',
    'io.ox/office/spreadsheet/model/cellmodelmatrix'
], function (AppHelper, SheetHelper, CellModel, CellModelMatrix) {

    'use strict';

    // convenience shortcuts
    var a = SheetHelper.a;

    // class CellModelMatrix ==================================================

    describe('Spreadsheet class CellModelMatrix', function () {

        it('should exist', function () {
            expect(CellModelMatrix).to.be.a('function');
        });

        // private helpers ----------------------------------------------------

        // the operations to be applied by the document model
        var OPERATIONS = [
            { name: 'setDocumentAttributes', attrs: { document: { cols: 16384, rows: 1048576 } } },
            { name: 'insertAutoStyle', styleId: 'a0', attrs: {}, default: true },
            { name: 'insertSheet', sheet: 0, sheetName: 'Sheet1' }
        ];

        // initialize test document
        var docModel = null, sheetModel = null, cellMatrix = null;
        AppHelper.createSpreadsheetApp('ooxml', OPERATIONS).done(function (app) {
            docModel = app.getModel();
            sheetModel = docModel.getSheetModel(0);
            cellMatrix = new CellModelMatrix(sheetModel, true);
        });

        // public methods -----------------------------------------------------

        describe('method "getUsedInterval"', function () {
            it('should exist', function () {
                expect(cellMatrix).to.respondTo('getUsedInterval');
            });
            it('should return null for empty matrix', function () {
                expect(cellMatrix.getUsedInterval()).to.equal(null);
            });
        });

        describe('method "insertModel"', function () {
            it('should exist', function () {
                expect(cellMatrix).to.respondTo('insertModel');
            });
            it('should insert cell models', function () {
                expect(cellMatrix.insertModel(new CellModel(a('A1')))).to.equal(cellMatrix);
                expect(cellMatrix.insertModel(new CellModel(a('A3')))).to.equal(cellMatrix);
                expect(cellMatrix.insertModel(new CellModel(a('A2')))).to.equal(cellMatrix);
                expect(cellMatrix.getUsedInterval()).to.stringifyTo('1:1');
                expect(cellMatrix.insertModel(new CellModel(a('C1')))).to.equal(cellMatrix);
                expect(cellMatrix.insertModel(new CellModel(a('B1')))).to.equal(cellMatrix);
                expect(cellMatrix.getUsedInterval()).to.stringifyTo('1:3');
            });
        });
    });

    // ========================================================================
});
