/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Michael Nimz <michael.nimz@open-xchange.com>
 */

define([
    'io.ox/office/portal/collection/documentcollection'
], function (DocumentCollection) {

    'use strict';

    // class DocumentCollection ===============================================

    describe('Portal class DocumentCollection', function () {

        it('should exist', function () {
            expect(DocumentCollection).to.be.a('function');
        });

        it('should have method "setData"', function () {
            var collection = new DocumentCollection();
            expect(collection).to.respondTo('setData');
        });

        it('should catch data', function () {
            var collection = new DocumentCollection();
            collection.setData([{ path: [] }, { path: [] }, { path: [] }]);
            expect(collection.length).to.be.equal(3);
        });

        it('filter out the first two elements from path', function () {
            var collection = new DocumentCollection();
            collection.setData([{ path: [{ id: '1', filename: 'IPM-Root' }, { id: '9', filename: 'Drive' }, { id: '1234', filename: 'My Files' }, { id: 'bla', filename: 'fasel' }] }]);
            expect(collection.models[0].get('path').length).to.be.equal(2);
        });
    });

    // ========================================================================
});
