/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define([
    'io.ox/office/baseframework/utils/baseconfig'
], function (BaseConfig) {

    'use strict';

    // static class BaseConfig ================================================

    describe('BaseFramework module BaseConfig', function () {

        it('should exist', function () {
            expect(BaseConfig).to.be.an('object');
        });
        it('should extend toolkit configuration', function () {
            expect(BaseConfig).to.have.a.property('DEBUG');
        });

        // constants ----------------------------------------------------------

        describe('constant "MAIL_AVAILABLE"', function () {
            it('should exist', function () {
                expect(BaseConfig).to.have.a.property('MAIL_AVAILABLE').that.is.a('boolean');
            });
        });

        describe('constant "CONTACTS_AVAILABLE"', function () {
            it('should exist', function () {
                expect(BaseConfig).to.have.a.property('CONTACTS_AVAILABLE').that.is.a('boolean');
            });
        });

        describe('constant "CONVERTER_AVAILABLE"', function () {
            it('should exist', function () {
                expect(BaseConfig).to.have.a.property('CONVERTER_AVAILABLE').that.is.a('boolean');
            });
        });

        describe('constant "GUARD_AVAILABLE"', function () {
            it('should exist', function () {
                expect(BaseConfig).to.have.a.property('GUARD_AVAILABLE').that.is.a('boolean');
            });
        });

        describe('constant "PRESENTER_AVAILABLE"', function () {
            it('should exist', function () {
                expect(BaseConfig).to.have.a.property('PRESENTER_AVAILABLE').that.is.a('boolean');
            });
        });

        describe('constant "REMOTE_PRESENTER_AVAILABLE"', function () {
            it('should exist', function () {
                expect(BaseConfig).to.have.a.property('REMOTE_PRESENTER_AVAILABLE').that.is.a('boolean');
            });
        });
    });

    // ========================================================================
});
