/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/textframework/view/control/drawingpositionpicker', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/control/radiolist',
    'gettext!io.ox/office/textframework/main'
], function (Utils, RadioList, gt) {

    'use strict';

    // class DrawingPositionPicker ============================================

    /**
     * Drop-down menu control for position and text floating of drawing objects
     * in text documents.
     *
     * @constructor
     *
     * @extends RadioList
     */
    function DrawingPositionPicker(docView, initOptions) {

        // base constructor ---------------------------------------------------

        RadioList.call(this, docView, Utils.extendOptions({
            icon: 'docs-drawing-inline',
            label: /*#. alignment and text floating of drawing objects in text documents */ gt.pgettext('drawing-pos', 'Position'),
            tooltip: /*#. alignment and text floating of drawing objects in text documents */ gt.pgettext('drawing-pos', 'Drawing position'),
            updateCaptionMode: 'icon',
            smallerVersion: {
                hideLabel: true
            }
        }, initOptions));

        // initialization -----------------------------------------------------

        this//.createMenuSection('inline')
            //.createOptionButton('inline',       { section: 'inline', icon: 'docs-drawing-inline',       label: /*#. drawing object position in paragraph */ gt.pgettext('drawing-pos', 'Inline with text') })
            .createMenuSection('left')
            .createOptionButton('left:none',    { section: 'left',   icon: 'docs-drawing-left-none',    label: /*#. drawing object position in paragraph */ gt.pgettext('drawing-pos', 'Left aligned, no text wrapping') })
            .createOptionButton('left:right',   { section: 'left',   icon: 'docs-drawing-left-right',   label: /*#. drawing object position in paragraph */ gt.pgettext('drawing-pos', 'Left aligned, text wraps at right side') })
            .createMenuSection('right')
            .createOptionButton('right:none',   { section: 'right',  icon: 'docs-drawing-right-none',   label: /*#. drawing object position in paragraph */ gt.pgettext('drawing-pos', 'Right aligned, no text wrapping') })
            .createOptionButton('right:left',   { section: 'right',  icon: 'docs-drawing-right-left',   label: /*#. drawing object position in paragraph */ gt.pgettext('drawing-pos', 'Right aligned, text wraps at left side') })
            .createMenuSection('center')
            .createOptionButton('center:none',  { section: 'center', icon: 'docs-drawing-center-none',  label: /*#. drawing object position in paragraph */ gt.pgettext('drawing-pos', 'Centered, no text wrapping') })
            .createOptionButton('center:left',  { section: 'center', icon: 'docs-drawing-center-left',  label: /*#. drawing object position in paragraph */ gt.pgettext('drawing-pos', 'Centered, text wraps at left side') })
            .createOptionButton('center:right', { section: 'center', icon: 'docs-drawing-center-right', label: /*#. drawing object position in paragraph */ gt.pgettext('drawing-pos', 'Centered, text wraps at right side') });

    } // class DrawingPositionPicker

    // exports ================================================================

    // derive this class from class RadioList
    return RadioList.extend({ constructor: DrawingPositionPicker });

});
