/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Michael Nimz <michael.nimz@open-xchange.com>
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/view/control/namesmenubutton', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/control/button',
    'io.ox/office/baseframework/view/control/compoundsplitbutton',
    'gettext!io.ox/office/spreadsheet/main'
], function (Utils, Button, CompoundSplitButton, gt) {

    'use strict';

    // class NamesMenuButton ==================================================

    /**
     * A compound button providing a shortcut to show the floating menu for all
     * defined names in the document, and a drop-down menu with additional
     * options.
     *
     * @constructor
     *
     * @extends CompoundSplitButton
     */
    var NamesMenuButton = CompoundSplitButton.extend({ constructor: function (docView) {

        // base constructor ---------------------------------------------------

        CompoundSplitButton.call(this, docView, Utils.extendOptions({
            label: gt.pgettext('named ranges', 'Named ranges'),
            tooltip: gt.pgettext('named ranges', 'Show or hide the named ranges in this document'),
            toggle: true,
            value: 'toggle'
        }));

        // initialization -----------------------------------------------------

        // create all drop-down menu items
        this.addGroup('name/insert/dialog', new Button(docView, { icon: 'fa-plus', label: gt.pgettext('named ranges', 'Add new range'), tooltip: gt.pgettext('named ranges', 'Add a named range') }));

        // destroy all class members on destruction
        this.registerDestructor(function () {
            docView = null;
        });

    } }); // class NamesMenuButton

    // exports ================================================================

    return NamesMenuButton;

});
