/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/drawing/imagemodel', [
    'io.ox/office/drawinglayer/model/imagemodel',
    'io.ox/office/spreadsheet/model/drawing/drawingmodelmixin'
], function (ImageModel, DrawingModelMixin) {

    'use strict';

    // class SheetImageModel ==================================================

    /**
     * The model of a image/picture object contained in a sheet.
     *
     * @constructor
     *
     * @extends ImageModel
     * @extends DrawingModelMixin
     *
     * @param {SheetModel} sheetModel
     *  The sheet model instance containing this image object.
     *
     * @param {DrawingCollection} parentCollection
     *  The parent drawing collection that will contain this drawing object.
     *
     * @param {Object} [initAttributes]
     *  An attribute set with initial formatting attributes for the object.
     */
    var SheetImageModel = ImageModel.extend({ constructor: function (sheetModel, parentCollection, initAttributes) {

        // base constructors --------------------------------------------------

        ImageModel.call(this, parentCollection, initAttributes);
        DrawingModelMixin.call(this, sheetModel, cloneConstructor);

        // private methods ----------------------------------------------------

        function cloneConstructor(targetModel, targetCollection) {
            return new SheetImageModel(targetModel, targetCollection, this.getExplicitAttributeSet(true));
        }

        // initialization -----------------------------------------------------

        // destroy all class members on destruction
        this.registerDestructor(function () {
            sheetModel = initAttributes = null;
        });

    } }); // class SheetImageModel

    // exports ================================================================

    return SheetImageModel;

});
