/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/presentation/view/toolbars', [
    'io.ox/office/baseframework/view/toolbar',
    'io.ox/office/textframework/view/toolbars',
    'io.ox/office/presentation/view/controls',
    'gettext!io.ox/office/presentation/main'
], function (ToolBar, TextBaseToolBars, Controls, gt) {

    'use strict';

    // static class PresentationToolBars ======================================

    /**
     * A static map with tool bar classes for presentation applications.
     *
     * @type Object
     * @constant
     */
    var PresentationToolBars = _.extend({}, TextBaseToolBars);

    // class SlideToolBar =====================================================

    PresentationToolBars.SlideToolBar = ToolBar.extend({ constructor: function (docView) {

        // base constructor ---------------------------------------------------

        ToolBar.call(this, docView, {
            shrinkToMenu: {
                icon: 'fa-file-powerpoint-o',
                tooltip: gt('Slide')
            }
        });

        // initialization -----------------------------------------------------

        // create the controls of this tool bar
        this.addGroup('layoutslidepicker/insertslide', new Controls.InsertLayoutSlidePicker(docView));
        this.addGap();
        this.addGroup('layoutslidepicker/changelayout', new Controls.ChangeLayoutSlidePicker(docView));

        // destroy all class members on destruction
        this.registerDestructor(function () { docView = null; });

    } }); // class SlideToolBar

    // exports ================================================================

    return PresentationToolBars;

});
