/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/drawinglayer/model/embeddedcollection', [
    'io.ox/office/drawinglayer/model/indexedcollection'
], function (IndexedCollection) {

    'use strict';

    // class EmbeddedCollection ===============================================

    /**
     * Represents a drawing collection that is embedded in a drawing model,
     * used e.g. by group objects.
     *
     * @constructor
     *
     * @extends IndexedCollection
     *
     * @param {DrawingModel} parentModel
     *  The parent drawing model that contains this embedded collection.
     */
    var EmbeddedCollection = IndexedCollection.extend({ constructor: function (parentModel) {

        // self reference
        var self = this;

        // base constructor ---------------------------------------------------

        IndexedCollection.call(this, parentModel.getDocModel(), modelFactory, { parentModel: parentModel });

        // private methods ----------------------------------------------------

        /**
         * Constructs a drawing model instance for the specified drawing type.
         *
         * @param {DrawingCollection} parentCollection
         *  The parent drawing collection that will contain the new drawing
         *  object.
         *
         * @param {String} type
         *  The type of the drawing model to be created.
         *
         * @param {Object} [attributeSet]
         *  Initial formatting attributes for the drawing model.
         *
         * @returns {DrawingModel|Null}
         *  The new drawing model instance, if the passed type is supported.
         */
        function modelFactory(parentCollection, drawingType, attributeSet) {
            // use the factory of the root collection to create the drawing models
            return self.getRootCollection().implCreateModel(parentCollection, drawingType, attributeSet);
        }

        // initialization -----------------------------------------------------

        // destroy all class members
        this.registerDestructor(function () {
            self = parentModel = null;
        });

    } }); // class EmbeddedCollection

    // exports ================================================================

    return EmbeddedCollection;

});
