/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Carsten Driesner <carsten.driesner@open-xchange.com>
 */

define('io.ox/office/baseframework/utils/clienterror', [
    'io.ox/office/baseframework/utils/errorcode'
], function (ErrorCode) {

    'use strict';

    // static class ClientError ===============================================

    var // the exported ClientError class
        ClientError = {};

    // constants --------------------------------------------------------------

    ClientError.ERROR_CONNECTION_RESET_RECEIVED = { error: 'ERROR_CONNECTION_RESET_RECEIVED', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_CONNECTION_NOT_MEMBER = { error: 'ERROR_CONNECTION_NOT_MEMBER', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_GENERAL_SYNCHRONIZATION_ERROR = { error: 'ERROR_GENERAL_SYNCHRONIZATION_ERROR', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_OFFLINE_WHILE_SYNCHRONIZING = { error: 'ERROR_OFFLINE_WHILE_SYNCHRONIZING', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_OFFLINE_WHILE_SYNC_LOCAL_CHANGES = { error: 'ERROR_OFFLINE_WHILE_SYNC_LOCAL_CHANGES', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_SYNCHRONIZATION_TIMEOUT = { error: 'ERROR_SYNCHRONIZATION_TIMEOUT', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_SYNCHRONIZATION_NOT_POSSIBLE = { error: 'ERROR_SYNCHRONIZATION_NOT_POSSIBLE', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_SYNCHRONIZATION_DOC_CHANGED = { error: 'ERROR_SYNCHRONIZATION_DOC_CHANGED', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_SYNCHRONIZATION_LOST_EDIT_RIGHTS = { error: 'ERROR_SYNCHRONIZATION_LOST_EDIT_RIGHTS', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_SYNCHRONIZATION_NOT_SUPPORTED = { error: 'ERROR_SYNCHRONIZATION_NOT_SUPPORTED', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_WHILE_MODIFYING_DOCUMENT = { error: 'ERROR_WHILE_MODIFYING_DOCUMENT', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_WHILE_LOADING_DOCUMENT = { error: 'ERROR_WHILE_LOADING_DOCUMENT', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_SIRI_NOT_SUPPORTED = { error: 'ERROR_SIRI_NOT_SUPPORTED', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_ANDROID_IME_NOT_SUPPORTED_KEYBOARD = { error: 'ERROR_ANDROID_IME_NOT_SUPPORTED_KEYBOARD', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_LOAD_DOC_FAILED_SERVER_TOO_BUSY = { error: 'ERROR_LOAD_DOC_FAILED_SERVER_TOO_BUSY', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_BAD_SERVER_COMPONENT_DETECTED = { error: 'ERROR_BAD_SERVER_COMPONENT_DETECTED', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_DOCUMENT_SIZE_EXCEEDED = { error: 'ERROR_DOCUMENT_SIZE_EXCEEDED', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_DOCUMENT_PASSWORD_PROTECTED = { error: 'ERROR_DOCUMENT_PASSWORD_PROTECTED', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_CONNECTION_TIMEOUT = { error: 'ERROR_CONNECTION_TIMEOUT', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_OFFLINE_WHILE_LOADING = { error: 'ERROR_OFFLINE_WHILE_LOADING', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_CONNECTION_HANGUP = { error: 'ERROR_CONNECTION_HANGUP', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_CONNECTION_JOIN_FAILED = { error: 'ERROR_CONNECTION_JOIN_FAILED', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_CONNECTIONINSTANCE_DISPOSED = { error: 'ERROR_CONNECTIONINSTANCE_DISPOSED', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_UNKNOWN_REALTIME_FAILURE = { error: 'ERROR_UNKNOWN_REALTIME_FAILURE', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.ERROR_SERVER_DENIES_CONNECTION = { error: 'ERROR_SERVER_DENIES_CONNECTION', errorClass: ErrorCode.ERRORCLASS_ERROR };
    ClientError.WARNING_READONLY_DUE_TO_OFFLINE = { error: 'WARNING_READONLY_DUE_TO_OFFLINE', errorClass: ErrorCode.ERRORCLASS_WARNING };
    ClientError.WARNING_CONNECTION_INSTABLE = { error: 'WARNING_CONNECTION_INSTABLE', errorClass: ErrorCode.ERRORCLASS_WARNING };
    ClientError.WARNING_NO_PERMISSION_FOR_DOC = { error: 'WARNING_NO_PERMISSION_FOR_DOC', errorClass: ErrorCode.ERRORCLASS_WARNING };
    ClientError.WARNING_DOC_IS_LOCKED = { error: 'WARNING_DOC_IS_LOCKED', errorClass: ErrorCode.ERRORCLASS_WARNING };
    ClientError.WARNING_SYNC_AFTER_OFFLINE = { error: 'WARNING_SYNC_AFTER_OFFLINE', errorClass: ErrorCode.ERRORCLASS_WARNING };
    ClientError.WARNING_SYNC_FOR_VIEWER = { error: 'WARNING_SYNC_FOR_VIEWER', errorClass: ErrorCode.ERRORCLASS_WARNING };
    ClientError.WARNING_RESCUE_DOC_CANNOT_BE_CHANGED = { error: 'WARNING_RESCUE_DOC_CANNOT_BE_CHANGED', errorClass: ErrorCode.ERRORCLASS_WARNING };

    // exports ================================================================

    return ClientError;

});
