Name:           open-xchange-documents-ui
Version:        7.4.2
%define         ox_release 7
Release:        %{ox_release}_<CI_CNT>.<B_CNT>
Group:          Applications/Productivity
Vendor:         Open-Xchange
URL:            http://www.open-xchange.com/
Packager:       Daniel Rentz <daniel.rentz@open-xchange.com>
License:        CC-BY-NC-SA-3.0
Summary:        OX Documents
Source:         %{name}_%{version}.orig.tar.bz2

#!BuildIgnore:  post-build-checks
BuildArch:      noarch
BuildRoot:      %{_tmppath}/%{name}-%{version}-root
BuildRequires:  open-xchange-appsuite-dev

Requires:       open-xchange-documents-ui-viewer
Requires:       open-xchange-documents-ui-editors

%description
Meta package for all Open-Xchange Documents web applications


%if 0%{?rhel_version} || 0%{?fedora_version}
%define docroot /var/www/html/appsuite
%else
%define docroot /srv/www/htdocs/appsuite
%endif

%package common
Group:          Applications/Productivity
Summary:        OX Viewer
Requires:       open-xchange-appsuite-manifest >= 7.4.1
Conflicts:      open-xchange-appsuite-manifest < 7.4.1
Conflicts:      open-xchange-appsuite-l10n-en-us < 7.4.1
Requires(post): open-xchange-appsuite-manifest >= 7.4.1

%description common
Common code for all Open-Xchange Documents web applications



%package viewer
Group:          Applications/Productivity
Summary:        OX Viewer
Requires:       open-xchange-documents-ui-common

%description viewer
The Open-Xchange Viewer web application


%package editors
Group:          Applications/Productivity
Summary:        OX Documents editors
Requires:       open-xchange-documents-backend
Requires:       open-xchange-documents-ui-common

%description editors
The Open-Xchange Documents editor applications

%package static
Group:          Applications/Productivity
Summary:        OX Documents 
Requires: 	open-xchange-appsuite

%description static
The Open-Xchange Documents 

%prep
%setup -q

%build

%install
sh /opt/open-xchange-appsuite-dev/bin/build-appsuite app skipLess=1 \
    builddir="%{buildroot}/opt/open-xchange/appsuite" \
    version=%{version} revision=%{release}
mkdir -p "%{buildroot}%{docroot}/apps/io.ox/office/baseframework/view"
cp -r "%{buildroot}/opt/open-xchange/appsuite/apps/io.ox/office/baseframework/view/" "%{buildroot}%{docroot}/apps/io.ox/office/baseframework/"

%clean
sh /opt/open-xchange-appsuite-dev/bin/build-appsuite clean skipLess=1 \
    builddir="%{buildroot}/opt/open-xchange/appsuite" \
    version=%{version} revision=%{release}

%define update /opt/open-xchange/appsuite/share/update-themes.sh

%post common
if [ -x %{update} ]; then %{update}; fi

%postun common
if [ -x %{update} ]; then %{update}; fi

%post viewer
if [ -x %{update} ]; then %{update}; fi

%postun viewer
if [ -x %{update} ]; then %{update}; fi

%post editors
if [ -x %{update} ]; then %{update}; fi

%postun editors
if [ -x %{update} ]; then %{update}; fi

%files
%defattr(-,root,root)
%doc README

%files common
%defattr(-,root,root)
%dir /opt/open-xchange
/opt/open-xchange/appsuite
%exclude /opt/open-xchange/appsuite/apps/io.ox/office/preview
%exclude /opt/open-xchange/appsuite/apps/io.ox/office/editframework
%exclude /opt/open-xchange/appsuite/apps/io.ox/office/drawinglayer
%exclude /opt/open-xchange/appsuite/apps/io.ox/office/text
%exclude /opt/open-xchange/appsuite/apps/io.ox/office/spreadsheet
%exclude /opt/open-xchange/appsuite/apps/io.ox/office/presentation
%exclude /opt/open-xchange/appsuite/manifests

%files viewer
%defattr(-,root,root)
/opt/open-xchange/appsuite/apps/io.ox/office/preview
/opt/open-xchange/appsuite/manifests/open-xchange-documents-ui-viewer.json

%files editors
%defattr(-,root,root)
/opt/open-xchange/appsuite/apps/io.ox/office/editframework
/opt/open-xchange/appsuite/apps/io.ox/office/drawinglayer
/opt/open-xchange/appsuite/apps/io.ox/office/text
/opt/open-xchange/appsuite/apps/io.ox/office/spreadsheet
/opt/open-xchange/appsuite/apps/io.ox/office/presentation
/opt/open-xchange/appsuite/manifests/open-xchange-documents-ui-editors.json

%files static
%defattr(-,root,root)
%dir %{docroot}
%dir %{docroot}/apps
%dir %{docroot}/apps/io.ox
%dir %{docroot}/apps/io.ox/office
%dir %{docroot}/apps/io.ox/office/baseframework
%dir %{docroot}/apps/io.ox/office/baseframework/view
%{docroot}/apps/io.ox/office/baseframework/view

%changelog
