/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/drawing/axismodel',
    ['io.ox/office/editframework/model/format/attributedmodel',
     'io.ox/office/editframework/model/format/color'], function (AttributedModel) {

    'use strict';

    // class AxisModel =====================================================


    function AxisModel(app, attrs, dataAxis) {

        // base constructor ---------------------------------------------------

        AttributedModel.call(this, app, attrs, { additionalFamilies: ['axis', 'line', 'gridline']});

        // methods ------------------------------------------------------------

        this.refreshInfo = function () {
            var attrs = this.getMergedAttributes();
            var cells = app.getModel().getStyleSheets('cell');


            if (attrs.line.fillType === 'none') {
                dataAxis.labelFontColor = null;
                dataAxis.lineColor = 'transparent';
                dataAxis.tickColor = 'transparent';
            } else if (attrs.axis.visible === true) {
                dataAxis.labelFontColor = null;
                dataAxis.lineColor = cells.getCssColor(attrs.line.color, 'line');
                dataAxis.tickColor = dataAxis.labelFontColor;
            } else {
                dataAxis.labelFontColor = 'transparent';
                dataAxis.lineColor = 'transparent';
                dataAxis.tickColor = 'transparent';
            }

            dataAxis.gridThickness = 1;
            dataAxis.gridColor = cells.getCssColor(attrs.axis.gridlineColor, 'fill');

        };


    } // class AxisModel

    // exports ================================================================

//    return AxisModel;
    return AttributedModel.extend({ constructor: AxisModel });

});
