/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/spreadsheet/view/chartcreator',
    ['io.ox/office/tk/utils',
     'io.ox/office/spreadsheet/utils/sheetutils',
     'io.ox/office/spreadsheet/model/operations',
     'gettext!io.ox/office/spreadsheet'
    ], function (Utils, SheetUtils, Operations, gt) {

    'use strict';

    // class ChartCreator =================================================

    function getCellName(x, y) {
        return '$' + SheetUtils.getColName(x) + '$' + SheetUtils.getRowName(y);
    }

    function addDataSeries(app, generator, sheet, position, series, keyFromX, keyFromY, keyToX, keyToY, titleX, titleY, valueFromX, valueFromY, valueToX, valueToY) {
        var sheetName = app.getModel().getSheetName(sheet);
        var options = {
            series: series,
            attrs: {
                series: {
                    title: sheetName + '!' + getCellName(titleX, titleY),
                    values: sheetName + '!' + getCellName(valueFromX, valueFromY) + ':' + getCellName(valueToX, valueToY),
                    names: sheetName + '!' + getCellName(keyFromX, keyFromY) + ':' + getCellName(keyToX, keyToY)
                }
            }
        };
        generator.generateDrawingOperation(Operations.INSERT_CHART_DATASERIES, sheet, position, options);
    }

    /**
     * ChartCreator makes an insert-Chart-Op and Insert-Chart-DataSeries chosen by current Selection
     * and changes the Selection to a Multiselection by title, names and values
     */
    function ChartCreator(app) {

        var view = app.getView();
        var gridPane = view.getActiveGridPane();

        var def = $.Deferred();

        var view = app.getView();
        var sheetModel = view.getActiveSheetModel();
        var drawingCollection = sheetModel.getDrawingCollection();

        var selection = view.getSelection();

        var range = selection.ranges[selection.activeRange];
        var start = range.start;
        var end = range.end;

        var width = end[0] - start[0];
        var height = end[1] - start[1];

        if (width > 50 || height > 50) {
            view.yell('warning', gt('It is not possible to create a chart out of more than 50 input cells.'));
            def.reject();
        } else {
            var rect = gridPane.getVisibleRectangle();
            var clip = {
                left: Math.round(rect.left + rect.width / 3),
                top: Math.round(rect.top + rect.height / 4),
                width: Math.round(rect.width / 3),
                height: Math.round(rect.height / 2)
            };

            var attrs = drawingCollection.getAttributesForRectangle(clip);

            attrs.chart = {
                    type: 'bar2d'
                };

            view.insertDrawing('chart', attrs, function (generator, sheet, position) {

                if (width > height) {
                    var keyFromX = start[0] + 1;
                    var keyFromY = start[1];
                    var keyToX = end[0];
                    var keyToY = start[1];

                    for (var i = 0; i < height; i++) {
                        var y = start[1] + 1 + i;

                        var titleX = start[0];
                        var valueFromX = start[0] + 1;
                        var valueToX = end[0];

                        addDataSeries(app, generator, sheet, position, i, keyFromX, keyFromY, keyToX, keyToY, titleX, y, valueFromX, y, valueToX, y);
                    }

                } else {
                    var keyFromX = start[0];
                    var keyFromY = start[1] + 1;
                    var keyToX = start[0];
                    var keyToY = end[1];

                    for (var i = 0; i < width; i++) {

                        var x = start[0] + 1 + i;

                        var titleY = start[1];
                        var valueFromY = start[1] + 1;
                        var valueToY = end[1];

                        addDataSeries(app, generator, sheet, position, i, keyFromX, keyFromY, keyToX, keyToY, x, titleY, x, valueFromY, x, valueToY);
                    }
                }
            });

            def.resolve();
        }

        /**
         * the deferred Object handles noting at the Moment,
         * its just for Future cases, when the situation could be changed
         * @return {Jquery|Deferred}
         */
        this.deferred = function () {
            return def;
        };
    }

    // exports ================================================================

    return ChartCreator;

});
