/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Carsten Driesner <carsten.driesner@open-xchange.com>
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/drawing/manualcolorchart',
        ['io.ox/office/tk/utils'], function (Utils) {

    'use strict';

    var BACKGROUNDTRANSFORMATION = [{type: 'satMod', value: 25000}, {type: 'lumOff', value: 35000}];

    var STYLESET = [{
        bg: {type: 'scheme', value: 'light1'},
        bevelEnabled: false
    }, {
        bg: {type: 'scheme', value: 'light1'},
        bevelEnabled: false
    }, {
        bg: {type: 'scheme', value: 'light1'},
        bevelEnabled: false
    }, {
        bg: {type: 'scheme', value: 'light1'},
        bevelEnabled: true
    }, {
        bg: null,
        bevelEnabled: false
    }, {
        bg: {type: 'scheme', value: 'background1', transformations: [{type: 'lumOff', value: -75000}]},
        bevelEnabled: true
    }];

    var COLORSET = [];

    (function () {
        var allAccents = [];
        for (var i = 1; i <= 6; i++) {
            allAccents.push({type: 'scheme', value: 'accent' + i});
        }
        COLORSET.push({ colors: [{type: 'rgb', value: '555555'}, {type: 'rgb', value: '9E9E9E'}, {type: 'rgb', value: '727272'}, {type: 'rgb', value: '464646'}, {type: 'rgb', value: '838383'}, {type: 'rgb', value: 'C1C1C1'}], variations: []});
        COLORSET.push({ colors: allAccents, variations: [{transformations: [{type: 'lumOff', value: -1000}]}]});



        var accentVariations = [];//[{transformations: [{type: 'lumOff', value: -10000}]}, null, {transformations: [{type: 'lumOff', value: 10000}]}, {transformations: [{type: 'lumOff', value: 20000}]}, {transformations: [{type: 'lumOff', value: 30000}]}, {transformations: [{type: 'lumOff', value: 40000}]}];

        for (var i = -2; i <= 3; i++) {
            accentVariations.push({transformations: [{type: 'lumOff', value: i * 8000}]});
        }

        for (var i = 0; i < allAccents.length; i++) {
            COLORSET.push({ colors: [allAccents[i]], variations: accentVariations});
        }
    })();

    //Bar Col Area

    function ManualColorChart(app, chartmodel, data) {
        //var self = this;
        //var docModel = app.getModel();

        data.colorSet = null;

        // private methods ------------------------------------------------------------

        function getColorOfPattern(meth, index, schemeColors, variations) {
            var variationIndex = null;
            var colorIndex = null;
            if (meth === 'cycle') {
                variationIndex = index % variations.length;
                colorIndex = index % schemeColors.length;
            } else {
                Utils.warn('cant handle color meth:' + meth);
                return null;
            }

            var color = schemeColors[colorIndex];
            var variation = variations[variationIndex];

            var tmpColor = {};
            tmpColor.type = color.type;
            tmpColor.value = color.value;
            if (variation) {
                tmpColor.transformations = variation.transformations;
            }
            return tmpColor;
        }

        function getColor(index) {
            var attributes = chartmodel.getMergedAttributes();

            var colors = attributes.chart.chartColors;
            if (colors) {
                //modern color pattern
                return getColorOfPattern(colors.meth, index, colors.schemeClr, colors.variation);
            } else if (attributes.chart.chartStyleId) {
                var styleId = attributes.chart.chartStyleId - 1;
                var styleSet = STYLESET[(styleId / 8)|0];
                var colorSet = COLORSET[styleId % 8];



                var dataSeries = data.data[index];
                dataSeries.bevelEnabled = styleSet.bevelEnabled;

                var res = getColorOfPattern('cycle', index, colorSet.colors, colorSet.variations);

                if (index === 0) {
                    var cells = app.getModel().getStyleSheets('cell');

                    var givenStyle = styleSet.bg;
                    if (!givenStyle) {
                        givenStyle = {type: res.type, value: res.value, transformations: BACKGROUNDTRANSFORMATION};

                    }

                    var bg = cells.getCssColor(givenStyle, 'fill');
                    data.backgroundColor = bg;
                }

                return {
                    color: res
                };
            } else {
                //Utils.warn('no color?', series, attrs.chart);
            }
        }

        // public functions ------------------------------------------------------------

        this.getLabelName = function () {
            return 'label';
        };

        this.handleColor = function (series, index) {
            if (!series.fill) {
                series.fill = getColor(index);
            }
            var dataSeries = data.data[index];
            var attributes = chartmodel.getMergedAttributes();
            if (series.fill && series.fill.color) {
                var cells = app.getModel().getStyleSheets('cell');
                dataSeries.color = cells.getCssColor(series.fill.color, 'fill');
                //Utils.warn('color?', dataSeries.color);
            }

            if (index === 0) {
                var bg = attributes.fill.color;
                if (bg && bg.type != 'auto') {
                    var cells = app.getModel().getStyleSheets('cell');
                    data.backgroundColor = cells.getCssColor(bg, 'fill');
                }


                //FIXME: this is a hack for the missing Outlines
                if (data.backgroundColor && data.backgroundColor === dataSeries.color) {
                    data.backgroundColor = 'rgb(200,200,200)';

                    data.FALLBACK = true;
                }
            }
            //FIXME:
            if (data.FALLBACK) {
                if (dataSeries.color == 'transparent') {
                    var red = 255 - (index * 8);
                    dataSeries.color = 'rgb(' + red + ',' + red + ',' + red + ')';
                }
            }
        };

    } // class ManualColorChart

    // exports ================================================================

    return _.makeExtendable(ManualColorChart);

});
