/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/drawinglayer/view/drawingcontrols',
    ['io.ox/office/tk/utils',
     'io.ox/office/baseframework/view/basecontrols',
     'gettext!io.ox/office/drawing'
    ], function (Utils, BaseControls, gt) {

    'use strict';

    var // class name shortcuts
        RadioList = BaseControls.RadioList;

    // static class DrawingControls ===========================================

    /**
     * Additional classes defining specialized GUI controls for drawing
     * objects.
     */
    var DrawingControls = {};

    // constants --------------------------------------------------------------

    /**
     * Standard options for the 'Delete drawing' button.
     *
     * @constant
     */
    DrawingControls.DELETE_DRAWING_OPTIONS = { icon: 'docs-drawing-remove', tooltip: gt('Delete drawing object') };

    // class ChartTypePicker ==================================================

    /**
     * A drop-down list with all supported chart types.
     *
     * @constructor
     *
     * @extends RadioList
     */
    DrawingControls.ChartTypePicker = RadioList.extend({ constructor: function (initOptions) {

        // base constructor ---------------------------------------------------

        RadioList.call(this, Utils.extendOptions({ tooltip: gt('Chart type') }, initOptions));

        // initialization -----------------------------------------------------

        this.createMenuSection('bar')
            .createOptionButton('bar', 'bar clustered',      { label: /*#. Type of a chart object: vertical filled bars */ gt('Bar Clustered') })
            .createOptionButton('bar', 'bar stacked',        { label: /*#. Type of a chart object: vertical filled bars */ gt('Bar Stacked') })
            .createOptionButton('bar', 'bar percentStacked', { label: /*#. Type of a chart object: vertical filled bars */ gt('Bar Percent') })
            .createMenuSection('column')
            .createOptionButton('column', 'column clustered',      { label: /*#. Type of a chart object: vertical filled bars */ gt('Column Clustered') })
            .createOptionButton('column', 'column stacked',        { label: /*#. Type of a chart object: vertical filled bars */ gt('Column Stacked') })
            .createOptionButton('column', 'column percentStacked', { label: /*#. Type of a chart object: vertical filled bars */ gt('Column Percent') })
            .createMenuSection('line')
            .createOptionButton('line', 'line standard',   { label: /*#. Type of a chart object: data points connected with lines */ gt('Line Clustered') })
            .createOptionButton('line', 'spline standard', { label: /*#. Type of a chart object: data points connected with lines */ gt('Spline Clustered') })
            .createMenuSection('area')
            .createOptionButton('area', 'area clustered',      { label: /*#. Type of a chart object: filled area between X axis and data points */ gt('Area Clustered') })
            .createOptionButton('area', 'area stacked',        { label: /*#. Type of a chart object: filled area between X axis and data points */ gt('Area Stacked') })
            .createOptionButton('area', 'area percentStacked', { label: /*#. Type of a chart object: filled area between X axis and data points */ gt('Area Percent') })
            .createMenuSection('scatter')
            .createOptionButton('scatter', 'scatter', { label: /*#. Type of a chart object: data points with X/Y coordinates connected with lines */ gt('Scatter') })
            .createOptionButton('scatter', 'bubble',  { label: /*#. Type of a chart object: data points with X/Y coordinates drawn as circles */ gt('Bubble') })
            .createMenuSection('pie')
            .createOptionButton('pie', 'pie',   { label: /*#. Type of a chart object: single pie */ gt('Pie') })
            .createOptionButton('pie', 'donut', { label: /*#. Type of a chart object: one or multiple concentric circles */ gt('Donut') });

    }}); // class ChartTypePicker

    // exports ================================================================

    return DrawingControls;

});
