/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/drawinglayer/view/drawingcontrols',
    ['io.ox/office/tk/utils',
     'io.ox/office/baseframework/view/basecontrols',
     'io.ox/office/drawinglayer/view/chartcolorsetpicker',
     'gettext!io.ox/office/drawing'
    ], function (Utils, BaseControls, ChartColorsetPicker, gt) {

    'use strict';

    // private constants --------------------------------------------------------------

    var // class name shortcuts
        BoundRadioLists = BaseControls.BoundRadioLists,
        RadioList = BaseControls.RadioList,

        STACKING_TYPES = [{value: 'standard', label: gt('Clustered')}, {value: 'stacked', label: gt('Stacked')}, {value: 'percentStacked', label: gt('Percent')}],
        STANDARD_TYPE = [{value: 'standard', label: gt('Standard')}],
        CHART_TYPES = [
            {value: 'bar',      entries: STACKING_TYPES,    label: /*#. Type of a chart object: horizontal filled bars */ gt('Bar')},
            {value: 'column',   entries: STACKING_TYPES,    label: /*#. Type of a chart object: vertical filled bars */ gt('Column')},
            {value: 'area',     entries: STACKING_TYPES,    label: /*#. Type of a chart object: filled area between X axis and data points */ gt('Area')},
            {value: 'line',     entries: STANDARD_TYPE,     label: /*#. Type of a chart object: data points connected with lines */ gt('Line')},
            {value: 'scatter',  entries: STANDARD_TYPE,     label: /*#. Type of a chart object: data points with X/Y coordinates connected with lines */ gt('Scatter') },
            {value: 'bubble',   entries: STANDARD_TYPE,     label: /*#. Type of a chart object: data points with X/Y coordinates drawn as circles */ gt('Bubble') },
            {value: 'pie',      entries: STANDARD_TYPE,     label: /*#. Type of a chart object: single pie */ gt('Pie') },
            {value: 'donut',    entries: STANDARD_TYPE,     label: /*#. Type of a chart object: one or multiple concentric circles */ gt('Donut') }
        ];

    // static class DrawingControls ===========================================

    /**
     * Additional classes defining specialized GUI controls for drawing
     * objects.
     */
    var DrawingControls = {};

    // constants --------------------------------------------------------------

    /**
     * Standard options for the 'Delete drawing' button.
     *
     * @constant
     */
    DrawingControls.DELETE_DRAWING_OPTIONS = { icon: 'docs-drawing-remove', tooltip: gt('Delete drawing object') };

    DrawingControls.CURVED_CHART_OPTIONS = { label: gt('Curved'), tooltip: gt('Curved'), toggle: true };

    DrawingControls.VARYCOLOR_CHART_OPTIONS = { label: gt('Vary color'), tooltip: gt('Vary color'), toggle: true };

    DrawingControls.CREATE_CHART_SERIES_OPTIONS = { label: gt('Sources'), tooltip: gt('Sources'), toggle: true };


    // class ChartTypePicker ==================================================

    /**
     * A drop-down list with all supported chart types.
     *
     * @constructor
     *
     * @extends BoundRadioLists
     */
    DrawingControls.ChartTypePicker = BoundRadioLists.extend({ constructor: function (catOptions, entOptions) {
        // base constructor ---------------------------------------------------

        BoundRadioLists.call(this, CHART_TYPES, Utils.extendOptions({ tooltip: gt('Chart type') }, catOptions), Utils.extendOptions({ tooltip: gt('Chart stacking') }, entOptions));

    }}); // class ChartTypePicker

    DrawingControls.ChartColorsetPicker = ChartColorsetPicker.extend({ constructor: function (app, options) {
        // base constructor ---------------------------------------------------

        ChartColorsetPicker.call(this, app, Utils.extendOptions({ label: gt('Color'), tooltip: gt('Chart colorset'), updateCaptionMode: 'none' }, options));

    }}); // class ChartTypePicker

    DrawingControls.ChartStylesetPicker = RadioList.extend({ constructor: function (options) {
        // base constructor ---------------------------------------------------

        RadioList.call(this, Utils.extendOptions({ label: gt('Style'), tooltip: gt('Chart styleset'), updateCaptionMode: 'none' }, options));

        this.createOptionButton('', 'ss0', { label: gt('Light'),      dataValue: 'ss0' });
        this.createOptionButton('', 'ss4', { label: gt('Colored'),    dataValue: 'ss4' });
        this.createOptionButton('', 'ss5', { label: gt('Dark'),       dataValue: 'ss5' });

    }}); // class ChartTypePicker


    // exports ================================================================

    return DrawingControls;

});
