/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/drawinglayer/view/chartstyleutil',
        [], function () {

    'use strict';

    var BACKGROUNDTRANSFORMATION = [{type: 'satMod', value: 25000}, {type: 'lumOff', value: 35000}];

    var STYLESET = [{
        bg: {type: 'scheme', value: 'light1'},
        bevelEnabled: false
    }, {
        bg: {type: 'scheme', value: 'light1'},
        bevelEnabled: false
    }, {
        bg: {type: 'scheme', value: 'light1'},
        bevelEnabled: false
    }, {
        bg: {type: 'scheme', value: 'light1'},
        bevelEnabled: true
    }, {
        bg: null,
        bevelEnabled: false
    }, {
        bg: {type: 'scheme', value: 'background1', transformations: [{type: 'lumOff', value: -75000}]},
        bevelEnabled: true
    }];

    var COLORSET = [];

    (function () {
        var allAccents = [];
        for (var i = 1; i <= 6; i++) {
            allAccents.push({type: 'scheme', value: 'accent' + i});
        }
        COLORSET.push({ name: 'Greyscale', colors: [{type: 'rgb', value: '555555'}, {type: 'rgb', value: '9E9E9E'}, {type: 'rgb', value: '727272'}, {type: 'rgb', value: '464646'}, {type: 'rgb', value: '838383'}, {type: 'rgb', value: 'C1C1C1'}], variations: []});
        COLORSET.push({ name: 'Accents', colors: allAccents, variations: [{transformations: [{type: 'lumOff', value: -1000}]}]});



        var accentVariations = [];//[{transformations: [{type: 'lumOff', value: -10000}]}, null, {transformations: [{type: 'lumOff', value: 10000}]}, {transformations: [{type: 'lumOff', value: 20000}]}, {transformations: [{type: 'lumOff', value: 30000}]}, {transformations: [{type: 'lumOff', value: 40000}]}];

        for (var i = -2; i <= 3; i++) {
            accentVariations.push({transformations: [{type: 'lumOff', value: i * 8000}]});
        }

        for (var i = 0; i < allAccents.length; i++) {
            COLORSET.push({ name: 'Accent' + (i + 1), colors: [allAccents[i]], variations: accentVariations});
        }
    })();

    /**
     * an infoholder for the 48 chartstyles, a combination of colorpatterns, backgroundcolors and highlighting
     */
    var ChartStyleUtil = {

    };

    /**
     * return a list of different combinations of backgrounds and highlights
     */
    ChartStyleUtil.getStyleSet = function () {
        return STYLESET;
    };

    /**
     * return a list of different combinations of grayscales and accents
     */
    ChartStyleUtil.getColorSet = function () {
        return COLORSET;
    };

    /**
     * returns the color-transformations for desaturate the first color in the used pattern
     */
    ChartStyleUtil.getBackgroundTransformation = function () {
        return BACKGROUNDTRANSFORMATION;
    };

    // exports ================================================================

    return ChartStyleUtil;

});
