/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/drawinglayer/view/chartcolorsetpicker',
    ['io.ox/office/baseframework/view/basecontrols',
     'io.ox/office/drawinglayer/view/chartstyleutil',
     'io.ox/office/tk/utils',
     'gettext!io.ox/office/drawing'], function (BaseControls, ChartStyleUtil, Utils, gt) {

    'use strict';

    var // class name shortcuts
        RadioList = BaseControls.RadioList,
        MAXCOLORS = 3;

    /**
     * a Radiolist for chart-colorpatterns
     * takes the color-patterns from ChartStyleUtil
     * and creates buttons with its first thee colors
     */
    function ChartColorsetPicker(app, initOptions) {
        var self = this;
//            colorBox = createColorHolder(MAXCOLORS - 1).css('margin-top', '2px');

        RadioList.call(this, initOptions);


        var COLORSET = ChartStyleUtil.getColorSet();

        function createItemHandler(event, buttonNode, sectionId, value) {
            var div = createColorHolder(MAXCOLORS);
            buttonNode.prepend(div);
            updateColor(value, div, MAXCOLORS);
        }

        function createColorHolder(max) {
            var res = $('<div>');
            for (var i = 0; i < max; i++) {
//                res.append($('<div>').addClass('color-button').addClass('button'));
                res.append($('<div>').css({
                    width: '22px',
                    height: '22px',
                    display: 'inline-block',
                    border: '1px solid rgba(0, 0, 0, 0.2)',
                    borderRadius: '2px',
                    margin: '1px',
                    marginTop: '3px'
                }));
            }
            return res;
        }

//        function updateHandler(colorset) {
//            updateColor(colorset, colorBox, MAXCOLORS - 1);
//        }

        function updateColor(colorsetName, div, max) {


            if (!colorsetName) {
                return;
            }
            var csId = colorsetName.replace('cs', '') | 0;
            var colorset = COLORSET[csId];

            var cells = app.getModel().getStyleSheets('cell');

            for (var i = 0; i < max; i++) {

                var variationIndex = i % colorset.variations.length;
                var colorIndex = i % colorset.colors.length;

                var colorsource = colorset.colors[colorIndex];
                var variation = colorset.variations[variationIndex];

                var color = {
                    type: colorsource.type,
                    value: colorsource.value
                };
                if (variation) {
                    color.transformations = variation.transformations;
                }

                var css = cells.getCssColor(color, 'fill');
                $(div.children()[i]).css('background-color', css);
            }
        }

//        self.getMenuButton().append(colorBox);
//        self.registerUpdateHandler(updateHandler);

        self.getMenu().on('create:item', createItemHandler);


        function initializeColorTable() {
            self.clearMenu();
            _(COLORSET).each(function (colorset, index) {
    //            console.warn('colorset', colorset, index);
                self.createOptionButton('', 'cs' + index, { tooltip: gt(colorset.name), dataValue: 'cs' + index });

            });
        }

        initializeColorTable();
        // insert color buttons in the drop-down menu after import and changed themes
        app.on('docs:import:success', initializeColorTable);
        app.getModel().getThemeCollection().on('triggered', initializeColorTable);

    }



    return RadioList.extend({ constructor: ChartColorsetPicker });

});
