/**
 * All content on this website (including text, images, source code and any
 * other original works), unless otherwise noted, is licensed under a Creative
 * Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2013 Mail: info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/text/utils/unitcontroller',
    ['io.ox/office/editframework/app/unitcontroller'], function (UnitController) {

    'use strict';

    /**
     * @param {BaseApplication} app is needed for grafical operation button
     * and for the 'remote:layoutdata' event, which is triggered,
     * when server pushes some changes in the sheet layout
     */
    function TextUnitController(app) {

        UnitController.call(this, app);

        var waitFlag = false;

        function waitForLayout(state) {
            if  (state === 'ready') {
                waitFlag = false;
                app.off('docs:state', waitForLayout);
                //app.getView().trigger('change:layoutdata');
                app.getController().update();
            }
        }

        /**
         * shows if the operation button should be highlighted
         */
        this.isActivated = function () {
            return waitFlag;
        };

        /**
         * activate the opearation button
         */
        this.activate = function () {
            waitFlag = true;
            app.on('docs:state', waitForLayout);
        };

    }

    return UnitController.extend({ constructor: TextUnitController });

});
