/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/text/app/config',
    ['io.ox/office/tk/utils',
     'io.ox/office/tk/config'
     ], function (Utils, Config) {

    'use strict';

    // static class TextConfig ================================================

    var TextConfig = _.clone(Config);

    /**
     * Returns the value of the configuration property 'spellingEnabled'.
     *
     * @returns {Boolean}
     *  Whether online spelling is enabled.
     */
    TextConfig.isSpellingEnabled = function () {
        return Utils.getBooleanOption(Config.get(), 'spellingEnabled', true);
    };

    /**
     * Returns the value of the configuration property 'maxTableColumns'.
     *
     * @returns {Number}
     *  Returns the integer number for the maximum allowed columns, or
     *  undefined, if the value is not specified.
     */
    TextConfig.getMaxTableColumns = function () {
        return Utils.getIntegerOption(Config.get(), 'maxTableColumns');
    };

    /**
     * Returns the value of the configuration property 'maxTableRows'.
     *
     * @returns {Number}
     *  Returns the integer number for the maximum allowed rows, or
     *  undefined, if the value is not specified.
     */
    TextConfig.getMaxTableRows = function () {
        return Utils.getIntegerOption(Config.get(), 'maxTableRows');
    };

    /**
     * Returns the value of the configuration property 'maxTableCells'.
     *
     * @returns {Number}
     *  Returns the integer number for the maximum allowed cells, or
     *  undefined, if the value is not specified.
     */
    TextConfig.getMaxTableCells = function () {
        return Utils.getIntegerOption(Config.get(), 'maxTableCells');
    };

    // exports ================================================================

    return TextConfig;

});
