/**
 * All content on this website (including text, images, source code and any
 * other original works), unless otherwise noted, is licensed under a Creative
 * Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2013 Mail: info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/editframework/app/unitcontroller',
    ['io.ox/office/tk/control/button',
     'io.ox/office/tk/config'], function (Button, Config) {

    'use strict';

    // class UnitController ===================================================

    /**
     * @param {BaseApplication} app is needed for graphical operation button
     * and for the events, which are triggered,
     * when server pushes some changes in the sheet layout
     */
    function UnitController(app) {
        var self = this;
        var model = app.getModel();
//        var view = app.getView();

        /**
         * hangs a tool box in the side pane, its in the DOM but invisible,
         * the button inside is activated by hand, but gets deactivated
         * if the 'remote:layoutdata' is triggered
         */
        function initToolBox() {
           //moved to EditView
        }

        function registerDefinitions() {
            var defs = {
                'selenium/waitforlayout': {
                    enable: function () { return model.getEditMode(); },
                    get: function () { return self.isActivated(); },
                    set: function () { self.activate(); }
                }
            };
            self.registerDefinitions(defs);
        }

        /**
         * shows if the operation button should be highlighted
         */
        this.isActivated = function () {};

        /**
         * activate the operation button
         */
        this.activate = function () {};

        // initialization -----------------------------------------------------

        if (Config.isDebug()) {

            registerDefinitions();

            //View and Listener initialization
            app.on('docs:init', initToolBox);
        }
    }

    // ========================================================================

    return _.makeExtendable(UnitController);

});
