/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/text/format/textdocumentstyles',
    ['io.ox/office/editframework/model/format/documentstyles',
     'io.ox/office/text/format/characterstyles',
     'io.ox/office/text/format/paragraphstyles',
     'io.ox/office/text/format/drawingstyles',
     'io.ox/office/text/format/tablestyles',
     'io.ox/office/text/format/tablerowstyles',
     'io.ox/office/text/format/tablecellstyles',
     'io.ox/office/text/format/pagestyles',
     'io.ox/office/text/format/lists'
    ], function (DocumentStyles, CharacterStyles, ParagraphStyles, DrawingStyles, TableStyles, TableRowStyles, TableCellStyles, PageStyles, Lists) {

    'use strict';

    var // default values of text document attributes
        TEXT_DOCUMENT_ATTRIBUTES = {

            defaultTabStop: 1270,   // default tab width: 0.5 inch

            zoom: { value: 100 }    // default zoom: 100%

        };

    // class TextDocumentStyles ===============================================

    /**
     * Provides the style sheet containers for all attribute families used in a
     * text document, and other containers collecting special formatting
     * information for the text document.
     *
     * @constructor
     *
     * @extends DocumentStyles
     *
     * @param {TextApplication} app
     *  The root application instance.
     */
    function TextDocumentStyles(app) {

        // base constructor ---------------------------------------------------

        DocumentStyles.call(this, app, TEXT_DOCUMENT_ATTRIBUTES);

        // initialization -----------------------------------------------------

        this.addStyleSheetsContainer(new CharacterStyles(app, this))
            .addStyleSheetsContainer(new ParagraphStyles(app, this))
            .addStyleSheetsContainer(new DrawingStyles(app, this))
            .addStyleSheetsContainer(new TableStyles(app, this))
            .addStyleSheetsContainer(new TableRowStyles(app, this))
            .addStyleSheetsContainer(new TableCellStyles(app, this))
            .addStyleSheetsContainer(new PageStyles(app, this))
            .addCustomContainer('lists', new Lists(app, this));

    } // class TextDocumentStyles

    // exports ================================================================

    // derive this class from class DocumentStyles
    return DocumentStyles.extend({ constructor: TextDocumentStyles });

});
