/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/format/sheetstyles',
    ['io.ox/office/tk/utils',
     'io.ox/office/editframework/model/format/stylesheets'
    ], function (Utils, StyleSheets) {

    'use strict';

    var // definitions for sheet attributes
        DEFINITIONS = {
            visible: { def: true },
            colWidth: { def: 2500 },
            rowHeight: { def: 500 }
        };

    // class SheetStyles ======================================================

    /**
     * Contains the style sheets for sheet formatting attributes.
     *
     * @constructor
     *
     * @extends StyleSheets
     *
     * @param {SpreadsheetApplication} app
     *  The root application instance.
     *
     * @param {SpreadsheetDocumentStyles} documentStyles
     *  Collection with the style containers of all style families.
     */
    function SheetStyles(app, documentStyles) {

        // base constructor ---------------------------------------------------

        StyleSheets.call(this, app, documentStyles, 'sheet', DEFINITIONS, {
            styleSheetSupport: false
        });

    } // class SheetStyles

    // exports ================================================================

    // derive this class from class StyleSheets
    return StyleSheets.extend({ constructor: SheetStyles });

});
