/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Ingo Schmidt-Rosbiegal <ingo.schmidt-rosbiegal@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/format/columnstyles',
    ['io.ox/office/tk/utils',
     'io.ox/office/editframework/model/format/stylesheets'
    ], function (Utils, StyleSheets) {

    'use strict';

    var // definitions for column attributes
        DEFINITIONS = {
            visible: { def: true },
            width: { def: 0 },
            autoFit: { def: true },
            customWidth: { def: false }
        };

    // class ColumnStyles =====================================================

    /**
     * Contains the style sheets for sheet column formatting attributes.
     *
     * @constructor
     *
     * @extends StyleSheets
     *
     * @param {SpreadsheetApplication} app
     *  The root application instance.
     *
     * @param {SpreadsheetDocumentStyles} documentStyles
     *  Collection with the style containers of all style families.
     */
    function ColumnStyles(app, documentStyles) {

        // base constructor ---------------------------------------------------

        StyleSheets.call(this, app, documentStyles, 'column', DEFINITIONS, {
            styleSheetSupport: false
        });

    } // class ColumnStyles

    // exports ================================================================

    // derive this class from class StyleSheets
    return StyleSheets.extend({ constructor: ColumnStyles });

});
