#
# All content on this website (including text, images, source
# code and any other original works), unless otherwise noted,
# is licensed under a Creative Commons License.
#
# http://creativecommons.org/licenses/by-nc-sa/2.5/
#
# Copyright (C) Open-Xchange Inc., 2006-2012
# Mail: info@open-xchange.com
#
# @author Daniel Rentz <daniel.rentz@open-xchange.com>
#

LD_LIBRARY_PATH="$MAGICK_HOME/lib"
DYLD_LIBRARY_PATH="$MAGICK_HOME/lib"

ICONSET_LESS=tmp/docs-icons.less
ICONSET16_BLACK=tmp/docs-icons-desktop-black.png
ICONSET16_WHITE=tmp/docs-icons-desktop-white.png
ICONSET32_BLACK=tmp/docs-icons-retina-black.png
ICONSET32_WHITE=tmp/docs-icons-retina-white.png

SOURCE_SIZE=16

mkdir tmp 2> /dev/null

# generate the CSS file and count existing icons

let ICON_SIZE=SOURCE_SIZE+2
let RETINA_SIZE=ICON_SIZE*2
cat header.txt > $ICONSET_LESS
echo ".io-ox-office-main i[class^=\"docs-\"] {" >> $ICONSET_LESS
echo "    width: ${ICON_SIZE}px;" >> $ICONSET_LESS
echo "    height: ${ICON_SIZE}px;" >> $ICONSET_LESS
INDEX=0
while read LINE; do
    TOKENS=($(echo ${LINE%%#*} | tr -d "\r"))
    LEN=${#TOKENS[@]}
    if [ $LEN -ge 2 ]; then
        FILENAMES[$INDEX]=${TOKENS[0]}
        let POSX=-INDEX*ICON_SIZE
        for TOKEN in ${TOKENS[@]:1}; do
            echo "    &.docs-$TOKEN { background-position: ${POSX}px 0; }" >> $ICONSET_LESS
        done
        let INDEX=INDEX+1
    fi
done < icons.txt
let ICONSET_WIDTH=ICON_SIZE*INDEX
let ICONSET_HEIGHT=ICON_SIZE
echo "    background-size: ${ICONSET_WIDTH}px ${ICONSET_HEIGHT}px;" >> $ICONSET_LESS
echo "}" >> $ICONSET_LESS

# generate the icon sets

convert -size ${ICONSET_WIDTH}x$ICONSET_HEIGHT xc:none $ICONSET16_BLACK
let ICONSET_WIDTH=ICONSET_WIDTH*2
let ICONSET_HEIGHT=ICONSET_HEIGHT*2
convert -size ${ICONSET_WIDTH}x$ICONSET_HEIGHT xc:none $ICONSET32_BLACK
INDEX=0
for FILENAME in ${FILENAMES[@]}; do
    let POSX=INDEX*ICON_SIZE+1
    let POSX2=POSX*2
    composite -geometry +${POSX}+1 "images/16/$FILENAME" $ICONSET16_BLACK $ICONSET16_BLACK
    composite -geometry +${POSX2}+2 "images/32/$FILENAME" $ICONSET32_BLACK $ICONSET32_BLACK
    let INDEX=INDEX+1
    echo -n .
done
convert $ICONSET16_BLACK -fuzz 100% -fill \#333333 -opaque \#333333 $ICONSET16_BLACK
convert $ICONSET16_BLACK -fuzz 100% -fill \#ffffff -opaque \#ffffff $ICONSET16_WHITE
convert $ICONSET32_BLACK -fuzz 100% -fill \#333333 -opaque \#333333 $ICONSET32_BLACK
convert $ICONSET32_BLACK -fuzz 100% -fill \#ffffff -opaque \#ffffff $ICONSET32_WHITE
echo .

