/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Ingo Schmidt-Rosbiegal <ingo.schmidt-rosbiegal@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/format/rowstyles',
    ['io.ox/office/tk/utils',
     'io.ox/office/editframework/model/format/stylesheets'
    ], function (Utils, StyleSheets) {

    'use strict';

    var // definitions for row attributes
        DEFINITIONS = {
            visible: { def: true },
            height: { def: 0 },
            customHeight: { def: false },
            customFormat: { def: false }
        };

    // class RowStyles ========================================================

    /**
     * Contains the style sheets for sheet row formatting attributes.
     *
     * @constructor
     *
     * @extends StyleSheets
     *
     * @param {SpreadsheetApplication} app
     *  The root application instance.
     *
     * @param {SpreadsheetDocumentStyles} documentStyles
     *  Collection with the style containers of all style families.
     */
    function RowStyles(app, documentStyles) {

        // base constructor ---------------------------------------------------

        StyleSheets.call(this, app, documentStyles, 'row', DEFINITIONS, {
            styleSheetSupport: false
        });

    } // class RowStyles

    // exports ================================================================

    // derive this class from class StyleSheets
    return StyleSheets.extend({ constructor: RowStyles });

});
