/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/format/drawingstyles',
    ['io.ox/office/tk/utils',
     'io.ox/office/drawinglayer/model/drawingstyles'
    ], function (Utils, DrawingStyles) {

    'use strict';

    var // definitions for spreadsheet-specific drawing attributes
        DEFINITIONS = {

            // object anchor --------------------------------------------------

            /**
             * Zero-based index of the column containing the leading border of
             * the drawing object.
             */
            startCol: { def: 0 },

            /**
             * The exact position of the leading border in the column, as ratio
             * of the column width (in the range [0,1]).
             */
            startColOffset: { def: 0 },

            /**
             * Zero-based index of the row containing the top border of the
             * drawing object.
             */
            startRow: { def: 0 },

            /**
             * The exact position of the top border in the row, as ratio of the
             * row height (in the range [0,1]).
             */
            startRowOffset: { def: 0 },

            /**
             * Zero-based index of the column containing the trailing border of
             * the drawing object.
             */
            endCol: { def: 0 },

            /**
             * The exact position of the trailing border in the column, as
             * ratio of the column width (in the range [0,1]).
             */
            endColOffset: { def: 0 },

            /**
             * Zero-based index of the row containing the bottom border of the
             * drawing object.
             */
            endRow: { def: 0 },

            /**
             * The exact position of the bottom border in the row, as ratio of
             * the row height (in the range [0,1]).
             */
            endRowOffset: { def: 0 }

        };

    // class SpreadsheetDrawingStyles =========================================

    /**
     * Contains the style sheets for drawing formatting attributes.
     *
     * @constructor
     *
     * @extends DrawingStyles
     *
     * @param {SpreadsheetApplication} app
     *  The root application instance.
     *
     * @param {DocumentStyles} documentStyles
     *  Collection with the style containers of all style families.
     */
    function SpreadsheetDrawingStyles(app, documentStyles) {

        // base constructor ---------------------------------------------------

        DrawingStyles.call(this, app, documentStyles, DEFINITIONS);

    } // class SpreadsheetDrawingStyles

    // exports ================================================================

    // derive this class from class DrawingStyles
    return DrawingStyles.extend({ constructor: SpreadsheetDrawingStyles });

});
