/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/format/documentstyles',
    ['io.ox/office/editframework/model/format/documentstyles',
     'io.ox/office/spreadsheet/model/format/characterstyles',
     'io.ox/office/spreadsheet/model/format/cellstyles',
     'io.ox/office/spreadsheet/model/format/columnstyles',
     'io.ox/office/spreadsheet/model/format/rowstyles',
     'io.ox/office/spreadsheet/model/format/sheetstyles',
     'io.ox/office/spreadsheet/model/format/drawingstyles'
    ], function (DocumentStyles, CharacterStyles, CellStyles, ColumnStyles, RowStyles, SheetStyles, DrawingStyles) {

    'use strict';

    var // default values of spreadsheet document attributes
        SPREADSHEET_DOCUMENT_ATTRIBUTES = {

            // number of columns in a sheet (2^14)
            cols: 1024,

            // number of rows in a sheet (2^20)
            rows: 1048576

        };

    // class SpreadsheetDocumentStyles ========================================

    /**
     * Provides the style sheet containers for all attribute families used in a
     * spreadsheet document, and other containers collecting special formatting
     * information for the spreadsheet document.
     *
     * @constructor
     *
     * @extends DocumentStyles
     *
     * @param {SpreadsheetApplication} app
     *  The root application instance.
     */
    function SpreadsheetDocumentStyles(app) {

        // base constructor ---------------------------------------------------

        DocumentStyles.call(this, app, SPREADSHEET_DOCUMENT_ATTRIBUTES);

        // initialization -----------------------------------------------------

        this.addStyleSheetsContainer(new CharacterStyles(app, this))
            .addStyleSheetsContainer(new CellStyles(app, this))
            .addStyleSheetsContainer(new ColumnStyles(app, this))
            .addStyleSheetsContainer(new RowStyles(app, this))
            .addStyleSheetsContainer(new SheetStyles(app, this))
            .addStyleSheetsContainer(new DrawingStyles(app, this));

    } // class SpreadsheetDocumentStyles

    // exports ================================================================

    // derive this class from class DocumentStyles
    return DocumentStyles.extend({ constructor: SpreadsheetDocumentStyles });

});
