/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/format/characterstyles',
    ['io.ox/office/tk/utils',
     'io.ox/office/editframework/model/format/color',
     'io.ox/office/editframework/model/format/stylesheets'
    ], function (Utils, Color, StyleSheets) {

    'use strict';

    var // definitions for character attributes
        DEFINITIONS = {

            fontName: { def: 'Arial' },
            fontSize: { def: 11 },
            bold: { def: false },
            italic: { def: false },
            underline: { def: false },
            strike: { def: 'none' },
            color: { def: Color.AUTO }
        },

        PARENT_FAMILIES = {
            cell: function (span) { return span.closest('.cell'); }
        };

    // class CharacterStyles ==================================================

    /**
     * Contains the style sheets for character formatting attributes. The CSS
     * formatting will be written to text span elements contained somewhere in
     * the cell elements.
     *
     * @constructor
     *
     * @extends StyleSheets
     *
     * @param {SpreadsheetApplication} app
     *  The root application instance.
     *
     * @param {SpreadsheetDocumentStyles} documentStyles
     *  Collection with the style containers of all style families.
     */
    function CharacterStyles(app, documentStyles) {

        // base constructor ---------------------------------------------------

        StyleSheets.call(this, app, documentStyles, 'character', DEFINITIONS, {
            styleSheetSupport: false,
            parentFamilies: PARENT_FAMILIES
        });

    } // class CharacterStyles

    // exports ================================================================

    // derive this class from class StyleSheets
    return StyleSheets.extend({ constructor: CharacterStyles });

});
