/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/format/cellstyles',
    ['io.ox/office/tk/utils',
     'io.ox/office/editframework/model/format/color',
     'io.ox/office/editframework/model/format/border',
     'io.ox/office/editframework/model/format/stylesheets'
    ], function (Utils, Color, Border, StyleSheets) {

    'use strict';

    var // definitions for cell attributes
        DEFINITIONS = {
            alignHor: { def: 'auto' },
            alignVert: { def: 'bottom' },
            wrapText: { def: false },
            numberFormat: { def: { id: 0, code: 'Standard' }, merge: mergeNumberFormat },
            fillColor: { def: Color.AUTO },
            borderLeft: { def: Border.NONE },
            borderRight: { def: Border.NONE },
            borderTop: { def: Border.NONE },
            borderBottom: { def: Border.NONE },
            borderInsideHor: { def: Border.NONE, scope: 'element' },
            borderInsideVert: { def: Border.NONE, scope: 'element' }
        };

    // global private functions ===============================================

    /**
     * Returns a number format attribute value that results from updating an
     * existing number format with another number format. Keeps the format
     * identifier of the existing number format, if the format codes of both
     * formats are equal, and the new number format does not contain an own
     * identifier.
     */
    function mergeNumberFormat(oldFormat, newFormat) {
        return (!('id' in newFormat) && (oldFormat.code === newFormat.code)) ? oldFormat : newFormat;
    }

    // class CellStyles =======================================================

    /**
     * Contains the style sheets for sheet cell formatting attributes.
     *
     * @constructor
     *
     * @extends StyleSheets
     *
     * @param {SpreadsheetApplication} app
     *  The root application instance.
     *
     * @param {SpreadsheetDocumentStyles} documentStyles
     *  Collection with the style containers of all style families.
     */
    function CellStyles(app, documentStyles) {

        // base constructor ---------------------------------------------------

        StyleSheets.call(this, app, documentStyles, 'cell', DEFINITIONS);

    } // class CellStyles

    // exports ================================================================

    // derive this class from class StyleSheets
    return StyleSheets.extend({ constructor: CellStyles });

});
