/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/main',
    ['io.ox/office/tk/utils',
     'io.ox/office/editframework/app/editapplication',
     'io.ox/office/spreadsheet/model/model',
     'io.ox/office/spreadsheet/view/view',
     'io.ox/office/spreadsheet/app/controller'
    ], function (Utils, EditApplication, SpreadsheetModel, SpreadsheetView, SpreadsheetController) {

    'use strict';

    // class SpreadsheetApplication ===========================================

    /**
     * The OX Spreadsheet application.
     *
     * @constructor
     *
     * @extends EditApplication
     *
     * @param {Object} [appOptions]
     *  A map of static application options, that have been passed to the
     *  static method BaseApplication.createLauncher().
     *
     * @param {Object} [launchOptions]
     *  A map of options to control the properties of the application. Supports
     *  all options supported by the base class EditApplication.
     */
    var SpreadsheetApplication = EditApplication.extend({ constructor: function (appOptions, launchOptions) {

        var // self reference
            self = this;

        // base constructor ---------------------------------------------------

        EditApplication.call(this, SpreadsheetModel, SpreadsheetView, SpreadsheetController, appOptions, launchOptions, {
            postProcessHandler: postProcessDocument,
            postProcessProgressSize: 0,
            importFailedHandler: prepareInvalidDocument,
            realTimeDelay: 10
        });

        // private methods ----------------------------------------------------

        /**
         * Post-processing of the document, after all its import operations
         * have been applied successfully.
         *
         * @returns {jQuery.Promise}
         *  The promise of a Deferred object that will be resolved when the
         *  document has been post-processed successfully; or rejected when the
         *  document is invalid, or an error has occurred.
         */
        function postProcessDocument() {
            // document must contain at least one sheet (returning a rejected Deferred
            // object will causes invocation of the prepareInvalidDocument() method)
            return (self.getModel().getSheetCount() === 0) ? $.Deferred().reject() : $.when();
        }

        /**
         * Will be called when importing the document fails for any reason.
         */
        function prepareInvalidDocument() {
            // document must contain at least one sheet, to prevent if-else
            // statements for empty documents at thousand places in the view code
            self.getModel().prepareInvalidDocument();
        }

    }}); // class SpreadsheetApplication

    // exports ================================================================

    return EditApplication.createLauncher('io.ox/office/spreadsheet', SpreadsheetApplication, { icon: 'icon-table' });

});
