/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/presentation/model/format/documentstyles',
    ['io.ox/office/editframework/model/format/documentstyles'
    ], function (DocumentStyles) {

    'use strict';

    var // default values of presentation document attributes
        PRESENTATION_DOCUMENT_ATTRIBUTES = {};

    // class PresentationDocumentStyles =======================================

    /**
     * Provides the style sheet containers for all attribute families used in a
     * presentation document, and other containers collecting special
     * formatting information for the presentation document.
     *
     * @constructor
     *
     * @extends DocumentStyles
     *
     * @param {PresentationApplication} app
     *  The root application instance.
     */
    function PresentationDocumentStyles(app) {

        // base constructor ---------------------------------------------------

        DocumentStyles.call(this, app, PRESENTATION_DOCUMENT_ATTRIBUTES);

        // initialization -----------------------------------------------------

    } // class PresentationDocumentStyles

    // exports ================================================================

    // derive this class from class DocumentStyles
    return DocumentStyles.extend({ constructor: PresentationDocumentStyles });

});
