@echo off
rem
rem     All content on this website (including text, images, source
rem     code and any other original works), unless otherwise noted,
rem     is licensed under a Creative Commons License.
rem
rem     http://creativecommons.org/licenses/by-nc-sa/2.5/
rem
rem     Copyright (C) Open-Xchange Inc., 2006-2012
rem     Mail: info@open-xchange.com
rem
rem     @author Daniel Rentz <daniel.rentz@open-xchange.com>
rem

setlocal

set CONVERT="%MAGICK_HOME%\convert"
set COMPOSITE="%MAGICK_HOME%\composite"

set ICONSET_LESS=tmp\docs-icons.less
set ICONSET16_BLACK=tmp\docs-icons-desktop-black.png
set ICONSET16_WHITE=tmp\docs-icons-desktop-white.png
set ICONSET32_BLACK=tmp\docs-icons-retina-black.png
set ICONSET32_WHITE=tmp\docs-icons-retina-white.png

set SOURCE_SIZE=16

if not exist tmp mkdir tmp

rem generate the CSS file and count existing icons

set /a ICON_SIZE=%SOURCE_SIZE%+2
type header.txt > %ICONSET_LESS%
echo .io-ox-office-main i[class^^="docs-"] { >> %ICONSET_LESS%
echo     width: %ICON_SIZE%px; >> %ICONSET_LESS%
echo     height: %ICON_SIZE%px; >> %ICONSET_LESS%
set INDEX=0
for /f "tokens=1,* eol=#" %%A in (icons.txt) do call :write_css_classes "%%B"
set /a ICONSET_WIDTH=%ICON_SIZE%*%INDEX%
set /a ICONSET_HEIGHT=%ICON_SIZE%
echo     background-size: %ICONSET_WIDTH%px %ICONSET_HEIGHT%px; >> %ICONSET_LESS%
echo } >> %ICONSET_LESS%

rem generate the icon sets

%CONVERT% -size %ICONSET_WIDTH%x%ICONSET_HEIGHT% xc:none %ICONSET16_BLACK%
set /a ICONSET_WIDTH*=2
set /a ICONSET_HEIGHT*=2
%CONVERT% -size %ICONSET_WIDTH%x%ICONSET_HEIGHT% xc:none %ICONSET32_BLACK%
set INDEX=0
for /f "tokens=1 eol=#" %%A in (icons.txt) do call :process_icon_file %%A
%CONVERT% %ICONSET16_BLACK% -fuzz 100%% -fill #333333 -opaque #333333 %ICONSET16_BLACK%
%CONVERT% %ICONSET16_BLACK% -fuzz 100%% -fill #ffffff -opaque #ffffff %ICONSET16_WHITE%
%CONVERT% %ICONSET32_BLACK% -fuzz 100%% -fill #333333 -opaque #333333 %ICONSET32_BLACK%
%CONVERT% %ICONSET32_BLACK% -fuzz 100%% -fill #ffffff -opaque #ffffff %ICONSET32_WHITE%

endlocal
exit /b

:write_css_classes
setlocal
set /a POSX=-(%INDEX%*%ICON_SIZE%)
for %%A in (%~1) do echo     ^&.docs-%%A { background-position: %POSX%px 0; } >> %ICONSET_LESS%
endlocal
set /a INDEX+=1
exit /b

:process_icon_file
setlocal
set /a POSX=(%INDEX%*%ICON_SIZE%+1)
set /a POSX2=(%POSX%*2)
%COMPOSITE% -geometry +%POSX%+1 "images\16\%1" %ICONSET16_BLACK% %ICONSET16_BLACK%
%COMPOSITE% -geometry +%POSX2%+2 "images\32\%1" %ICONSET32_BLACK% %ICONSET32_BLACK%
endlocal
set /a INDEX+=1
exit /b
