/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/operations',
    ['io.ox/office/tk/utils',
     'io.ox/office/framework/model/operationsgenerator'
    ], function (Utils, OperationsGenerator) {

    'use strict';

    // class SpreadsheetOperationsGenerator ===================================

    /**
     * An instance of this class contains an operations array and provides
     * methods to generate operations for various element nodes.
     *
     * @constructor
     *
     * @extends OperationsGenerator
     *
     * @param {SpreadsheetDocumentStyles} documentStyles
     *  Global collection with the style sheet containers and custom formatting
     *  containers of a spreadsheet document.
     */
    function SpreadsheetOperationsGenerator(documentStyles) {

        // base constructor ---------------------------------------------------

        OperationsGenerator.call(this, documentStyles);

        // methods ------------------------------------------------------------

    } // class SpreadsheetOperationsGenerator

    // constants --------------------------------------------------------------

    _(SpreadsheetOperationsGenerator).extend({

        INSERT_SHEET: 'insertSheet',
        DELETE_SHEET: 'deleteSheet',
        MOVE_SHEET: 'moveSheet',

        INSERT_CELLS: 'insertCells',
        DELETE_CELLS: 'deleteCells',

        SET_SHEET_NAME: 'setSheetName',
        SET_SHEET_ATTRIBUTES: 'setSheetAttributes',

        SET_ROW_ATTRIBUTES: 'setRowAttributes',
        SET_COLUMN_ATTRIBUTES: 'setColumnAttributes',

        FILL_CELL_RANGE: 'fillCellRange',
        SET_CELL_CONTENTS: 'setCellContents'

    });

    // exports ================================================================

    // derive this class from class OperationsGenerator
    return OperationsGenerator.extend({ constructor: SpreadsheetOperationsGenerator });

});
