/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/presentation/model/model',
    ['io.ox/office/tk/utils',
     'io.ox/office/framework/model/editmodel',
     'io.ox/office/framework/model/operationsgenerator',
     'io.ox/office/presentation/model/format/documentstyles'
    ], function (Utils, EditModel, OperationsGenerator, PresentationDocumentStyles) {

    'use strict';

    // class PresentationModel ================================================

    /**
     * Represents the document model of a presentation application.
     *
     * Triggers the events supported by the base class EditModel.
     *
     * @constructor
     *
     * @extends EditModel
     *
     * @param {PresentationApplication} app
     *  The application containing this document model.
     */
    function PresentationModel(app) {

        var // self reference
            self = this,

            // container for all style sheets of all attribute families
            documentStyles = new PresentationDocumentStyles(app);

        // base constructor ---------------------------------------------------

        EditModel.call(this, app, OperationsGenerator, documentStyles);

        // private methods ----------------------------------------------------

        // methods ------------------------------------------------------------

        // initialization -----------------------------------------------------

    } // class PresentationModel

    // exports ================================================================

    // derive this class from class EditModel
    return EditModel.extend({ constructor: PresentationModel });

});
