/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config.docu.parser;

import com.openexchange.config.docu.parser.DocumentationGenerator;
import com.openexchange.config.docu.parser.PropertiesPrepared;
import com.openexchange.config.docu.parser.Property;
import com.openexchange.config.docu.parser.YamlFile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;

public class PropertiesGenerator
implements DocumentationGenerator<PropertiesPrepared> {
    @Override
    public PropertiesPrepared prepareOutputData(List<YamlFile> yamlFiles, String version, String chosenPackage) {
        HashMap<String, List<Property>> fileNameToProperties = new HashMap<String, List<Property>>();
        for (YamlFile ymlFile : yamlFiles) {
            for (Property propertie : ymlFile.getProperties()) {
                LinkedList<Property> liste;
                List<Property> properties;
                if (this.isNullOrEmpty(chosenPackage)) {
                    properties = fileNameToProperties.get(propertie.getFile());
                    if (properties == null) {
                        liste = new LinkedList<Property>();
                        liste.add(propertie);
                        fileNameToProperties.put(propertie.getFile(), liste);
                        continue;
                    }
                    properties.add(propertie);
                    continue;
                }
                if (propertie.getPackageName() == null || !propertie.getPackageName().equals(chosenPackage)) continue;
                properties = fileNameToProperties.get(propertie.getFile());
                if (properties == null) {
                    liste = new LinkedList();
                    liste.add(propertie);
                    fileNameToProperties.put(propertie.getFile(), liste);
                    continue;
                }
                properties.add(propertie);
            }
        }
        PropertiesPrepared p = new PropertiesPrepared(fileNameToProperties);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(PropertiesPrepared prepared, File destination) throws IOException {
        for (Map.Entry<String, List<Property>> entry : prepared.getFileNameToProperties().entrySet()) {
            File etcDir;
            String key = entry.getKey();
            List<Property> values = entry.getValue();
            if (key == null) {
                key = "others";
            }
            if (!(etcDir = new File(destination, "properties")).exists() && !etcDir.mkdir()) {
                throw new IOException("The properties folder could not be created successfully!");
            }
            File file = new File(etcDir, key);
            String fc = this.generateFileContent(values);
            Properties properties = new Properties();
            try {
                properties.load(new StringReader(fc));
            }
            catch (IllegalArgumentException e) {
                throw new IOException("The property file contains illegal characters: " + file.getName(), e);
            }
            FileWriter fw = new FileWriter(file);
            try {
                fw.write(fc);
            }
            finally {
                fw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateFileContent(List<Property> values) throws IOException {
        String output = null;
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        try {
            ListIterator<Property> it = values.listIterator();
            while (it.hasNext()) {
                Property prop = it.next();
                String text = prop.getDescription().trim().replaceAll("\r\n", "\n").replaceAll("\n", "\n# ");
                bw.write("# ");
                bw.write(text);
                bw.newLine();
                bw.write(35);
                bw.newLine();
                bw.write("#");
                bw.write(" Cascading: ");
                bw.write(String.valueOf(prop.isConfigcascadeAware()));
                bw.newLine();
                bw.write("#");
                bw.write(" Reloadable: ");
                bw.write(String.valueOf(prop.isReloadable()));
                bw.newLine();
                Object related = prop.getRelated();
                if (related instanceof String) {
                    bw.write("#");
                    bw.write(" Related: ");
                    bw.write(related.toString());
                    bw.newLine();
                } else if (related instanceof List) {
                    List relatedList = (List)related;
                    bw.write("#");
                    bw.write(" Related:");
                    bw.newLine();
                    for (Object stringob : relatedList) {
                        if (stringob == null) continue;
                        bw.write("# - ");
                        bw.write(stringob.toString());
                        bw.newLine();
                    }
                } else if (related != null) {
                    String finalstr = related.toString();
                    bw.write("#");
                    bw.write(" Related: ");
                    bw.write(finalstr);
                    bw.newLine();
                }
                bw.write("#");
                bw.newLine();
                if (prop.getDefaultValue() == null) {
                    bw.write("#");
                    bw.write(" Default: ");
                    bw.write("<empty>");
                    bw.newLine();
                } else {
                    bw.write("#");
                    bw.write(" Default: ");
                    bw.write(prop.getDefaultValue());
                    bw.newLine();
                }
                if (prop.getDefaultValue() == null) {
                    bw.write(prop.getKey());
                    bw.write(" =");
                    bw.newLine();
                } else {
                    bw.write(prop.getKey());
                    bw.write(" = ");
                    bw.write(prop.getDefaultValue());
                    bw.newLine();
                }
                if (it.hasNext()) {
                    bw.newLine();
                }
                bw.flush();
                output = sw.toString();
            }
        }
        finally {
            try {
                bw.close();
            }
            finally {
                sw.close();
            }
        }
        return output;
    }

    public boolean isNullOrEmpty(String str) {
        if (str == null) {
            return true;
        }
        return str.trim().length() == 0;
    }
}

