package com.openexchange.mobile.api.facade.configuration.clientspecific;

import com.openexchange.mobile.api.facade.utils.UserAgentInfo;

import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public abstract class AbstractStringMatchCriteria implements MatchCriteria {

    protected final String string;

    public abstract String getString(UserAgentInfo userAgentInfo);

    @Override
    public boolean matches(UserAgentInfo userAgentInfo) {
        String toCompare = getString(userAgentInfo);
        return toCompare.equals(string);
    }

}
