/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.mobile.api.facade.connectors.impl;

import java.util.List;

import com.openexchange.mobile.api.facade.auth.LoginCredentials;
import com.openexchange.mobile.api.facade.auth.SessionData;
import com.openexchange.mobile.api.facade.auth.impl.LoginConnector;
import com.openexchange.mobile.api.facade.auth.impl.LogoutConnector;
import com.openexchange.mobile.api.facade.connectors.ConnectorFactory;
import com.openexchange.mobile.api.facade.connectors.RequestConfiguration;
import com.openexchange.mobile.api.facade.endpoints.requests.AutoconfigData;
import com.openexchange.mobile.api.facade.models.Folder;
import com.openexchange.mobile.api.facade.models.MailAccountData;
import com.openexchange.mobile.api.facade.models.MailFlags;
import com.openexchange.mobile.api.facade.utils.RequestUtil;

public class DefaultConnectorFactory implements ConnectorFactory {

    private final RequestConfiguration configuration;

    public DefaultConnectorFactory() {
        configuration = RequestUtil.createConfiguration();
    }

    @Override
    public GetAccountConnector getAccountConnector(SessionData sessionData, String accountId) {
        return new GetAccountConnector(configuration, sessionData, accountId);
    }

    @Override
    public AccountsConnector getAccountsConnector(SessionData sessionData) {
        return new AccountsConnector(configuration, sessionData);
    }

    @Override
    public AllCapabilitiesConnector getAllCapabilities(SessionData sessionData) {
        return new AllCapabilitiesConnector(configuration, sessionData);
    }

    @Override
    public AllFoldersConnector getAllFoldersConnector(SessionData sessionData, String rootFolderId, String language) {
        return new AllFoldersConnector(configuration, sessionData, rootFolderId, language);
    }

    @Override
    public ClearFolderConnector getClearFolderConnector(SessionData sessionData, String folderId) {
        return new ClearFolderConnector(configuration, sessionData, folderId);
    }

    @Override
    public ConfigConnector getConfigConnector(SessionData sessionData) {
        return new ConfigConnector(configuration, sessionData);
    }

    @Override
    public ContactsConnector getContactsConnector(SessionData sessionData) {
        return new ContactsConnector(configuration, sessionData);
    }

    @Override
    public DeleteAccountConnector getDeleteAccountConnector(SessionData sessionData, String accountId) {
        return new DeleteAccountConnector(configuration, sessionData, accountId);
    }

    @Override
    public CreateFolderConnector getCreateFolderConnector(SessionData sessionData, String parentFolderId, String name) {
        return new CreateFolderConnector(configuration, sessionData, parentFolderId, name);
    }

    @Override
    public UpdateFolderConnector getUpdateFolderConnector(SessionData sessionData, String folderId, String newParentFolderId, String newName) {
        return new UpdateFolderConnector(configuration, sessionData, folderId, newParentFolderId, newName);
    }

    @Override
    public DeleteFolderConnector getDeleteFolderConnector(SessionData sessionData, String folderId) {
        return new DeleteFolderConnector(configuration, sessionData, folderId);
    }

    @Override
    public DeleteMailsConnector getDeleteMailsConnector(SessionData sessionData, String folderId, List<String> mailIds, boolean purge) {
        return new DeleteMailsConnector(configuration, sessionData, folderId, mailIds, purge);
    }

    @Override
    public EnvelopesConnector getEnvelopesConnector(SessionData sessionData, String folderId, List<String> mailIds) {
        return new EnvelopesConnector(configuration, sessionData, folderId, mailIds);
    }

    @Override
    public ExamineMultipleFoldersConnector getExamineFolderConnector(SessionData sessionData, String folderId) {
        return new ExamineMultipleFoldersConnector(configuration, sessionData, folderId);
    }

    @Override
    public ExamineMultipleFoldersConnector getExamineMultipleFoldersConnector(SessionData sessionData, List<Folder> folderIds) {
        return new ExamineMultipleFoldersConnector(configuration, sessionData, folderIds);
    }

    @Override
    public GetMailConnector getGetMailConnector(SessionData sessionData, String folderId, String mailId) {
        return new GetMailConnector(configuration, sessionData, folderId, mailId);
    }

    @Override
    public LoginConnector getLoginConnector(LoginCredentials credentials) {
        return new LoginConnector(configuration, credentials);
    }

    @Override
    public LogoutConnector getLogoutConnector(SessionData sessionData) {
        return new LogoutConnector(configuration, sessionData);
    }

    @Override
    public CreateAccountConnector getCreateAccountConnector(SessionData sessionData, MailAccountData account) {
        return new CreateAccountConnector(configuration, sessionData, account);
    }

    @Override
    public ManifestsConnector getManifestsConnector() {
        return new ManifestsConnector(configuration);
    }

    @Override
    public MoveMailsConnector getMoveMailsConnector(SessionData sessionData, String folderId, List<String> mailIds, String targetFolderId) {
        return new MoveMailsConnector(configuration, sessionData, folderId, mailIds, targetFolderId);
    }

    @Override
    public PnsSubscribeConnector getPnsSubscribeConnector(SessionData sessionData, String transport, String token, List<String> topics) {
        return new PnsSubscribeConnector(configuration, sessionData, transport, token, topics);
    }

    @Override
    public PnsUnsubscribeConnector getPnsUnsubscribeConnector(SessionData sessionData, String transport, String token) {
        return new PnsUnsubscribeConnector(configuration, sessionData, transport, token);
    }

    @Override
    public SetAndClearFlagsConnector getSetAndClearFlagsConnector(SessionData sessionData, String folderId, List<String> mailIds, MailFlags flags, boolean value) {
        return new SetAndClearFlagsConnector(configuration, sessionData, folderId, flags, mailIds, value);
    }

    @Override
    public SetColorsConnector getSetColorsConnector(SessionData sessionData, String folderId, List<String> mailIds, int color) {
        return new SetColorsConnector(configuration, sessionData, folderId, color, mailIds);
    }

    @Override
    public StubsConnector getStubsConnector(SessionData sessionData, String folderId, boolean threaded) {
        return new StubsConnector(configuration, sessionData, folderId, threaded);
    }

    @Override
    public ThreadedAllStubsConnector getThreadedAllStubsConnector(SessionData sessionData, String folderId) {
        return new ThreadedAllStubsConnector(configuration, sessionData, folderId);
    }

    @Override
    public ThreadReferencesConnector getThreadReferencesConnector(SessionData sessionData, String folderId) {
        return new ThreadReferencesConnector(configuration, sessionData, folderId);
    }

    @Override
    public UpdateAccountConnector getUpdateAccountConnector(SessionData sessionData, MailAccountData account) {
        return new UpdateAccountConnector(configuration, sessionData, account);
    }

    @Override
    public UserConnector getUserConnector(SessionData sessionData) {
        return new UserConnector(configuration, sessionData);
    }

    @Override
    public ValidateAccountConnector getValidateAccountConnector(SessionData sessionData, MailAccountData account, boolean forceInsecureConnection) {
        return new ValidateAccountConnector(configuration, sessionData, account, forceInsecureConnection);
    }

    @Override
    public VersionConnector getVersionConnector() {
        return new VersionConnector(configuration);
    }

    @Override
    public GetJsLobConnector getGetJsLobConnector(SessionData sessionData, String name) {
        return new GetJsLobConnector(configuration, sessionData, name);
    }

    @Override
    public AutoconfigureAccountConnector getAutoconfigureAccountConnector(SessionData sessionData, AutoconfigData autoconfigData) {
        return new AutoconfigureAccountConnector(configuration, sessionData, autoconfigData);
    }

}
