/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.mobile.api.facade.connectors.impl;

import java.nio.charset.Charset;
import java.util.List;

import com.openexchange.java.Strings;
import com.openexchange.mobile.api.facade.auth.SessionData;
import com.openexchange.mobile.api.facade.connectors.AbstractResponseMto;
import com.openexchange.mobile.api.facade.connectors.BaseConnector;
import com.openexchange.mobile.api.facade.connectors.RequestConfiguration;

import lombok.SneakyThrows;

import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;

public class PnsSubscribeConnector extends BaseConnector<AbstractResponseMto> {

    private final String transport;

    private final String token;

    private final List<String> topics;

    public PnsSubscribeConnector(RequestConfiguration configuration, SessionData sessionData, String transport, String token, List<String> topics) {
        super(configuration, sessionData, "pns", AbstractResponseMto.class);
        this.transport = transport;
        this.token = token;
        this.topics = topics;
    }

    @Override
    protected HttpUriRequest createRequest() {
        RequestBuilder builder = RequestBuilder.put(createUrl());
        builder.setCharset(Charset.forName("UTF-8"));
        addSessionData(builder);
        builder.addParameter("action", "subscribe");
        builder.setEntity(createEntity());
        return builder.build();
    }

    @SneakyThrows
    private HttpEntity createEntity() {
        String topicsToSend = Strings.join(topics, "\",\"");
        String body = String.format("{\"transport\":\"%s\",\"token\":\"%s\",\"topics\":[\"%s\"]}", transport, token, topicsToSend);
        return new StringEntity(body, "UTF-8");
    }

}
