package com.openexchange.mobile.api.facade.configuration.clientspecific;

import com.vdurmont.semver4j.Semver;
import com.vdurmont.semver4j.Semver.SemverType;

import lombok.Value;

@Value
public class VersionRange {

    Semver fromVersion;

    Semver upToVersion;

    public VersionRange(String value) {
        int indexDash = value.indexOf('-');
        if (indexDash < 0) {
            fromVersion = new Semver(value, SemverType.LOOSE);
            upToVersion = new Semver(value, SemverType.LOOSE);
        } else if (indexDash == 0) {
            fromVersion = null;
            upToVersion = new Semver(value.substring(1), SemverType.LOOSE);
        } else if (indexDash == value.length() - 1) {
            fromVersion = new Semver(value.substring(0, indexDash), SemverType.LOOSE);
            upToVersion = null;
        } else {
            fromVersion = new Semver(value.substring(0, indexDash), SemverType.LOOSE);
            upToVersion = new Semver(value.substring(indexDash + 1), SemverType.LOOSE);
        }
    }

}
