# Defines the Java options for the mobile API facade Java virtual machine.
JAVA_OPTS_GC="-XX:+UseConcMarkSweepGC"
JAVA_OPTS_LOG="-Dlogback.threadlocal.put.duplicate=false -XX:-OmitStackTraceInFastThrow"
JAVA_OPTS_MEM="-XX:MaxHeapSize=512M -XX:+UseTLAB"
JAVA_OPTS_NET=""
JAVA_OPTS_OSGI="-Dosgi.compatibility.bootdelegation=false"
JAVA_OPTS_SERVER="-server -Djava.awt.headless=true"

JAVA_OPTS_OTHER=""

# Define options for debugging the mobile API facade Java virtual machine, disabled by default.
#JAVA_OPTS_DEBUG="-XX:+HeapDumpOnOutOfMemoryError -XX:HeapDumpPath=/mnt/heapdump -Xloggc:/var/log/open-xchange/mobile-api-facade/gc.log -verbose:gc -XX:+PrintGCDateStamps -XX:+PrintHeapAtGC -XX:+PrintGCApplicationStoppedTime -XX:+PrintTenuringDistribution"

# Maximum number of open Files for the facade. This value will only be
# applied when using sysv init. For systemd have a look at the drop-in configs
# at /etc/systemd/system/open-xchange-mobile-api-facade.service.d
NRFILES=65536

# Maximum number of processes or more precisely threads for the facade. This
# value will only be applied when using sysv init. For systemd have a look at
# the drop-in configs at /etc/systemd/system/open-xchange-mobile-api-facade.service.d
NPROC=65536
